% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold_fun.R
\name{thresh_est}
\alias{thresh_est}
\title{Threshold estimation}
\usage{
thresh_est(z, lambda, tau, a = 3, penalty = c("MCP", "SCAD", "lasso"))
}
\arguments{
\item{z}{a vector where the function is to be evaluated.}

\item{lambda}{a number representing a tuning parameter.}

\item{tau}{the penalty parameter in the ADMM method.}

\item{a}{the tuning parameter of the MCP/SCAD penalty (see details).
Default is 3 for MCP and 3.7 for SCAD.}

\item{penalty}{The penalty to be applied to the model. Either "lasso" (the default), "SCAD",
or "MCP".}
}
\value{
A vector containing the threshlding values at z.
}
\description{
Function to implement the soft-, MCP, SCAD thresholding rule in the ADMM method.
}
\references{
{'Pairwise Fusion Approach Incorporating Prior Constraint Information' by Yaguang Li}
}
