% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anchored_lasso_and_related.R
\name{estimate_nuisance_parameter_lasso}
\alias{estimate_nuisance_parameter_lasso}
\title{The function for nuisance parameter estimation in anchored_lasso_testing().}
\usage{
estimate_nuisance_parameter_lasso(
  nuisance_sample_1,
  nuisance_sample_2,
  pca_method = "sparse_pca",
  mean_method = "lasso",
  lasso_tuning_method = "min",
  num_latent_factor = 1,
  local_environment = local_environment,
  verbose = TRUE
)
}
\arguments{
\item{nuisance_sample_1}{Group 1 sample. Each row is a subject and each column corresponds to a feature.}

\item{nuisance_sample_2}{Group 2 sample. Each row is a subject and each column corresponds to a feature.}

\item{pca_method}{Methods used to estimate principle component The default is "sparse_pca", using sparse PCA from package PMA. Other choices are "dense_pca"---the regular PCA; and "hard"--- hard-thresholding PCA, which also induces sparsity.}

\item{mean_method}{Methods used to estimate the discriminant direction. Default is logistic Lasso "lasso". Can also take value "lasso_no_truncation"}

\item{lasso_tuning_method}{Method for Lasso penalty hyperparameter tuning. Default is "min", the minimizer of cross-validation error; users can also use "1se" for more sparse solutions.}

\item{num_latent_factor}{The principle component that lasso coefficient anchors at. The default is PC1 = 1.}

\item{local_environment}{An environment for hyperparameters shared between folds.}

\item{verbose}{Print information to the console. Default is TRUE.}
}
\value{
A list of estimated nuisance quantities.
\item{estimate_leading_pc}{Leading principle components}
\item{estimate_mean_1}{Sample mean for group 1}
\item{estimate_mean_2}{Sample mean for group 1}
\item{estimate_lasso_beta}{Logistic Lasso regression coefficients.}
\item{estimate_projection_direction}{Anchored projection direction. It is similar to PC1 when signal is weak but similar to estimate_optimal_direction when the signal is moderately large.}
\item{estimate_optimal_direction}{Discriminant direction.}
}
\description{
The function for nuisance parameter estimation in anchored_lasso_testing().
}
