% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BDstrat.R
\name{BDstrat}
\alias{BDstrat}
\title{Stratify BIGDAWG Datasets by Specific Alleles}
\usage{
BDstrat(dataset, alleles, warnBelow = 21)
}
\arguments{
\item{dataset}{A BIGDAWG-formatted data frame or a path to a BIGDAWG-formatted, tab-delimited text file.}

\item{alleles}{A vector of allele names in the locus-asterisk-allele_name format (e.g., "A*01:01:01:01").}

\item{warnBelow}{An integer that defines a low number of subjects in a stratum, generating a warning message. The default value is 21.}
}
\value{
A list-object of two BIGDAWG-formatted data frames titled dataset$\verb{<alleles>-positive} and dataset$\verb{<alleles>-negative}. The positive list element includes all subjects with the specified alleles, and the negative list element includes all subjects without those specified alleles.
}
\description{
Divides a BIGDAWG-formatted dataset into two subsets (strata) that do and do not include specified alleles.
}
\examples{
HLA_data.multi.strat <- BDstrat(sHLAdata,c("DRB1*16:02:01:01","DRB1*04:07:01:01","A*25:01:01:01"))
HLA_data.single.strat <- BDstrat(sHLAdata,"DRB1*16:02:01:01")

}
\references{
\href{https://CRAN.R-project.org/package=BIGDAWG/vignettes/BIGDAWG.html#input-data}{BIGDAWG Data Format}
}
