% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\name{vb}
\alias{vb}
\title{Make an instance of class "VB"}
\usage{
vb(nb, dim, bdim = NULL, numst, varorder = NULL)
}
\arguments{
\item{nb}{The number of variable blocks.}

\item{dim}{Dimensionality of the data.}

\item{bdim}{An integer vector specifying dimensionality of each variable block.
This argument can be omitted if the variable block structure has a single
block (case of GMM).}

\item{numst}{An integer vector specifying the number of mixture models in each 
variable block.}

\item{varorder}{A list of integer vectors specifying the variable order in 
each variable block. This argument can be omitted if variable structure has a single
variable block (GMM).}
}
\value{
An object of class "VB".
}
\description{
This function creates a variable block structure.
}
\examples{
# variable block structure for GMM with 3 dimensions and 2 mixture states
Vb <- vb(1, dim=3, numst=2)

# variable block structure with 2 variable blocks
Vb <- vb(2, dim=10, bdim=c(4,6), numst=c(3,11), varorder=list(c(1:4),c(5:10)))
}
\seealso{
\code{\link{VB}}
}
