% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispatchers.R
\name{CovarEstim}
\alias{CovarEstim}
\title{Covariance matrix estimator}
\usage{
CovarEstim(x, type = c("trad", "BGP14", "LW20"), ...)
}
\arguments{
\item{x}{a p by n matrix or a data frame of asset returns. Rows represent
different assets, columns -- observations.}

\item{type}{a character. The estimation method to be used.}

\item{...}{arguments to pass to estimators}
}
\value{
an object of class matrix
}
\description{
It is a function dispatcher for covariance matrix estimation. One can choose
between traditional and shrinkage-based estimators.
}
\details{
The available estimation methods are:\tabular{lll}{
   Function \tab Paper \tab Type \cr
   \code{\link{Sigma_sample_estimator}} \tab  \tab traditional \cr
   \code{\link{CovShrinkBGP14}} \tab Bodnar et al 2014 \tab BGP14 \cr
   \code{\link{nonlin_shrinkLW}} \tab Ledoit & Wolf 2020 \tab LW20 \cr
}
}
\examples{
n<-3e2 # number of realizations
p<-.5*n # number of assets

x <- matrix(data = rnorm(n*p), nrow = p, ncol = n)

Mtrx_trad <- CovarEstim(x, type="trad")

TM <- matrix(0, p, p)
diag(TM) <- 1
Mtrx_bgp <- CovarEstim(x, type="BGP14", TM=TM)

Mtrx_lw <- CovarEstim(x, type="LW20")
}
