% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LarsPath.R
\name{coef.LarsPath}
\alias{coef.LarsPath}
\title{Compute coefficients}
\usage{
\method{coef}{LarsPath}(object, index = NULL, mode = c("lambda", "step",
  "fraction", "norm"), ...)
}
\arguments{
\item{object}{a LarsParth object}

\item{index}{If mode ="norm", index represents the l1-norm of the coefficients with which we want to predict.
If mode="fraction", index represents the ratio (l1-norm of the coefficientswith which we want to predict)/(l1-norm maximal of the LarsPath object).
If mode="lambda", index represents the value of the penalty parameter. If mode="step", index represents the numer of the step at which we want coefficients.}

\item{mode}{"fraction" or "norm" or "lambda" or "step".}

\item{...}{other arguments. Not used}
}
\value{
A vector containing the estimated coefficient for index
}
\description{
Compute coefficients at a given level of penalty
}
\examples{
dataset=simul(50,10000,0.4,10,50,matrix(c(0.1,0.8,0.02,0.02),nrow=2))
result=HDlars(dataset$data[1:40,],dataset$response[1:40])
coeff=coef(result,0.3,"fraction")
}
\seealso{
\code{\link{HDlars}} \code{\link{LarsPath}}
}
\author{
Quentin Grimonprez
}
