% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HCV.R
\name{synthetic_data}
\alias{synthetic_data}
\title{Generating Point-level Data Having Several Groups}
\usage{
synthetic_data(k, f, r, n, feature, geometry, homogeneity = TRUE)
}
\arguments{
\item{k}{integer specifying the number of groups.}

\item{f}{positive number controlling the concentration of generated samples toward large groups.}

\item{r}{positive number controlling the variance of individual attributes on the feature domain.}

\item{n}{integer specifying the total number of sampled points.}

\item{feature}{integer specifying the number of attributes for the feature domain.}

\item{geometry}{integer specifying the number of attributes for the geometry domain.}

\item{homogeneity}{logical indicating whether to force the centers of the feature domain to be the same as those of the geometry domain. Default is TRUE.}
}
\value{
A list with two matrices and a vector of labels. One matrix is for the feature domain and the other is for the geometry domain, both of which have  \emph{n} sampled points. The vector of labels indicates which cluster each sample belongs to.
}
\description{
Generation of synthetic point-level data based on a method proposed by Lin et al. (2005).
}
\examples{
set.seed(0)
pcase <- synthetic_data(3,30,0.02,100,2,2)
oldpar <- par(no.readonly = TRUE)  
par(mfrow=c(1,2))
labcolor <- (pcase$labels+1)\%\%3+1
plot(pcase$feat, col = labcolor, pch=19, xlab = 'First attribute', 
  ylab = 'Second attribute', main = 'Feature domain')
plot(pcase$geo, col = labcolor, pch=19, xlab = 'First attribute', 
  ylab = 'Second attribute', main = 'Geometry domain')
par(oldpar)

}
\references{
Lin, C. R., Liu, K. H., and Chen, M. S. (2005). Dual clustering: integrating data clustering over optimization and constraint domains. IEEE Transactions on Knowledge and Data Engineering, 17(5), 628-637.
}
\author{
ShengLi Tzeng and Hao-Yun Hsu.
}
