% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HCV.R
\name{tessellation_adjacency_matrix}
\alias{tessellation_adjacency_matrix}
\title{Adjacency Matrix from Tessellation}
\usage{
tessellation_adjacency_matrix(geometry_domain)
}
\arguments{
\item{geometry_domain}{\emph{n} by \emph{d} matrix (NA not allowed) of geographical coordinates for \emph{n} points in \emph{d}-dimensional space.}
}
\value{
A matrix with 0-1 values indicating the adjacency between the \emph{n} input points.
}
\description{
This function deals with spatial data having a point-level geometry domain.  It converts the spatial proximity into an adjacency matrix based on Voronoi tessellation or Delaunay triangulation.
}
\examples{
require(fields)
require(alphahull)
pts <- ChicagoO3$x
rownames(pts) <- LETTERS[1:20]
Vcells <- delvor(pts)
plot(Vcells,wlines='vor',pch='.')
text(pts,rownames(pts))
Amat <- tessellation_adjacency_matrix(pts)  
}
\references{
Gallier, J. (2011). Dirichlet–Voronoi Diagrams and Delaunay Triangulations. In Geometric Methods and Applications (pp. 301-319). Springer, New York, NY.
}
\author{
ShengLi Tzeng and Hao-Yun Hsu.
}
