package de.fhg.iais.kd.djm;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

import de.fhg.iais.kd.djm.ClientConnection.Mode;

public class PerformDocParser {

	public PerformDocument parseInputDoc(DataInputStream in) throws IOException {
		
		StringBuffer sbLine= new StringBuffer();
		ArrayList<String>  outputFilesIn = new ArrayList<String>();//parsed outputFiles
		ArrayList<OutputFile>  outputFiles = new ArrayList<OutputFile>();
		ArrayList<String>  inputFilesIn = new ArrayList<String>();//parsed inputFiles
		ArrayList<InputFile>  inputFiles = new ArrayList<InputFile>();
		ArrayList<String>  toDelete = new ArrayList<String>();
		PerformDocument performDoc = new PerformDocument();
		
		int data =0;
		while ((data= in.read())>=0) {
			if ((char)data != '\n') {
				sbLine.append((char)data);
				continue;
			}	
			String line = sbLine.toString();
			sbLine = new StringBuffer();
			
        	//System.out.println(line);
        	
			line=line.trim();
			if(line.startsWith("<mode>") && line.endsWith("</mode>")){
				String sMode = line.substring(line.indexOf(">")+1, line.lastIndexOf("<")).trim();
				try{
					performDoc.setMode(Mode.valueOf(Mode.class, sMode));
				}
				catch(Exception e)
				{
					//TODO add modes here
					throw new RuntimeException("wrong mode\n",e);
		    		
				}
			}
			else if(line.startsWith("<execIp>") && line.endsWith("</execIp>"))
				performDoc.setExecIp(line.substring(line.indexOf(">")+1, line.lastIndexOf("<")).trim());
			else if(line.startsWith("<localVar>") && line.endsWith("</localVar>"))
				performDoc.setLocalVar(line.substring(line.indexOf(">")+1, line.lastIndexOf("<")).trim());
			else if(line.startsWith("<executable>") && line.endsWith("</executable>"))
				performDoc.setExecutable(line.substring(line.indexOf(">")+1, line.lastIndexOf("<")).trim());
			else if(line.startsWith("<username>") && line.endsWith("</username>"))
				performDoc.setUsername(line.substring(line.indexOf(">")+1, line.lastIndexOf("<")).trim());
			else if(line.startsWith("<key>") && line.endsWith("</key>"))
				performDoc.setKey(line.substring(line.indexOf(">")+1, line.lastIndexOf("<")).trim());
			else if(line.startsWith("<outputFile>") && line.endsWith("</outputFile>"))
				outputFilesIn.add(line.substring(line.indexOf(">")+1, line.lastIndexOf("<")).trim());
			else if(line.startsWith("<inputFile>") && line.endsWith("</inputFile>"))
				inputFilesIn.add(line.substring(line.indexOf(">")+1, line.lastIndexOf("<")).trim());
			else if(line.startsWith("<deleteFile>") && line.endsWith("</deleteFile>"))
				toDelete.add(line.substring(line.indexOf(">")+1, line.lastIndexOf("<")).trim());
			else if(line.startsWith("<arguments>") && line.endsWith("</arguments>"))
				performDoc.setArguments(line.substring(line.indexOf(">")+1, line.lastIndexOf("<")).trim());
			else if(line.startsWith("<remoteDir>") && line.endsWith("</remoteDir>"))
			{
				String remDir = line.substring(line.indexOf(">")+1, line.lastIndexOf("<")).trim();
				if (remDir.endsWith("/"))
					remDir= remDir.substring(0, remDir.length()-1);
				if (remDir.endsWith("\\"))
					remDir= remDir.substring(0, remDir.length()-2);
				performDoc.setRemoteDir(remDir);
			}
			else if(line.startsWith("<block>") && line.endsWith("</block>"))
				performDoc.setBlock(new Boolean(line.substring(line.indexOf(">")+1, line.lastIndexOf("<")).trim()));
			else if(line.startsWith("<id>") && line.endsWith("</id>")){
				try{
					performDoc.setId(Integer.valueOf(line.substring(line.indexOf(">")+1, line.lastIndexOf("<")).trim()));
				} catch (Exception e){
					throw new RuntimeException("cannot parse id to int\n",e);
				}
			}
				
			else if(line.startsWith("</job>"))
				break;
			else if(line.startsWith("<job>")){}
			else
			{
				//unknown command:
				throw new RuntimeException("command: " + line + " is unknown, aborting\n");
			}
			

       }
		//check if inputFiles contains a filesize at the end
		for(int i=0;i<inputFilesIn.size();i++){
	
			String file =inputFilesIn.get(i);
			//find the ":" which separates the name and size
			int pos = file.lastIndexOf(":");
			if(pos==-1)
			{
				//no filezise added
				inputFiles.add(new InputFile(file, 0));
			}
			else
			{
				String filename = file.substring(0, pos);
				String sSize = file.substring(pos+1);
				try{
					int size = Integer.parseInt(sSize);
					inputFiles.add(new InputFile(filename, size));
				} catch(Exception e){
					//if there is an exception, a globus file is found, thus save it without dir and size
					inputFiles.add(new InputFile(file));
				}
				
			}
		}
		//add ip to outputFiles
		for(int i=0;i<outputFilesIn.size();i++){
			if(outputFilesIn.get(i).startsWith("gsiftp://") || outputFilesIn.get(i).startsWith("file://"))
				outputFiles.add(new OutputFile(outputFilesIn.get(i), performDoc.getExecIp(), performDoc.getRemoteDir()));
			else
				outputFiles.add(new OutputFile(new File(outputFilesIn.get(i)).getName(), performDoc.getExecIp(), performDoc.getRemoteDir()));
		}
		performDoc.setOutputFiles(outputFiles);
		performDoc.setInputFiles(inputFiles);
		performDoc.setToDelete(toDelete);
		return performDoc;
	}
}
