package de.fhg.iais.kd.djm;

import java.util.ArrayList;

public class JobDescription {
	protected enum Status {waitingForInputFiles, submitted, done, error, errorNew, uploadResult};
	protected enum JobType{condorJob, globusJob, fileExecution};
	protected JobType jobType;
	protected Status status;
	protected String executable;
	protected String username;
	protected String arguments;
	protected String remoteDir;
	protected String execIp;
	protected String localVar;
	protected ArrayList<OutputFile> outputFiles;
	protected ArrayList<InputFile> inputFiles;
	protected ArrayList<String> toDelete;
	protected String error="";
	protected Thread threadID = null;
	protected String globusId = null;
	protected int condorId = -1;
	protected String globusEprFile=null;
	protected String jobFile=null;
	

	JobDescription(JobType jobType, Status status, String localVar, String executable, String execIp, String arguments, String remoteDir, String username, ArrayList<OutputFile> outputFiles, ArrayList<InputFile> inputFiles, Thread threadID){
		this.jobType = jobType;
		this.status = status;
		this.localVar = localVar;
		this.executable = executable;
		this.execIp = execIp;
		this.arguments = arguments;
		this.remoteDir	 = remoteDir;
		this.username = username;
		this.outputFiles = outputFiles;
		this.inputFiles = inputFiles;
		this.threadID = threadID;
		toDelete = new ArrayList<String>();
	}
	
	public String getLocalVar() {
		return localVar;
	}

	public void setLocalVar(String localVar) {
		this.localVar = localVar;
	}

	public ArrayList<String> getToDelete() {
		return toDelete;
	}
	public void setToDelete(ArrayList<String> toDelete) {
		this.toDelete = toDelete;
	}
	public String getJobFile() {
		return jobFile;
	}
	public void setJobFile(String jobFile) {
		this.jobFile = jobFile;
	}
	public String getGlobusEprFile() {
		return globusEprFile;
	}
	public void setGlobusEprFile(String globusEprFile) {
		this.globusEprFile = globusEprFile;
	}
	public String getGlobusId() {
		return globusId;
	}
	public JobType getJobType() {
		return jobType;
	}
	public void setGlobusId(String globusId) {
		this.globusId = globusId;
	}
	public int getCondorId() {
		return condorId;
	}
	public void setCondorId(int condorId) {
		this.condorId = condorId;
	}
	public void setStatus(Status status){
		this.status = status;
	}
	public void setError(String error){
		this.error+=error;
	}
	public Status getStatus() {
		return status;
	}
	public String getExecutable() {
		return executable;
	}
	public String getExecIp() {
		return execIp;
	}
	public String getUsername() {
		return username;
	}
	public String getArguments() {
		return arguments;
	}
	public String getRemoteDir() {
		return remoteDir;
	}
	public ArrayList<OutputFile> getOutputFiles() {
		return outputFiles;
	}
	public ArrayList<InputFile> getInputFiles() {
		return inputFiles;
	}
	public void setInputFiles(ArrayList<InputFile> inputfile) {
		this.inputFiles = inputfile;
	}
	public String getError() {
		return error.replace("\n", " ");
	}
	public Thread getThreadId() {
		return threadID;
	}
}
