% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_document.R
\name{docx_document}
\alias{docx_document}
\title{Formatter wrapper for \code{\link[rmarkdown]{html_document}}, facilitates easier porting to docx}
\usage{
docx_document(
  ...,
  self_contained = FALSE,
  mathjax = NULL,
  theme = NULL,
  highlight = NULL,
  css = "rmarkdown/docx.css",
  h1_style = "margin: 24pt 0pt 0pt 0pt;",
  other_h_style = "margin: 10pt 0pt 0pt 0pt;",
  remove_scripts = TRUE,
  force_captions = FALSE,
  css_max_width
)
}
\arguments{
\item{...}{Passed onto \code{\link[rmarkdown]{html_document}}.}

\item{self_contained}{Overrides the default \code{TRUE} for
\code{\link[rmarkdown]{html_document}} to \code{FALSE} as
LibreOffice hangs on long lines such as the base64
images included in the self-contained version.}

\item{mathjax}{The advanced mathjax does not work with with
Word/LibreOffice.}

\item{theme}{No theme should be used for the output as the
custom CSS should take care of everything.}

\item{highlight}{By default turn off highlighting as scripts
are difficult to import. This does though work somewhat OK when
copy-pasting from the web-browser.}

\item{css}{The CSS if other that the default within the package}

\item{h1_style}{You can choose any css style formatting here that you
want to be applied to all h1 elements. Note: this is only applied
if LibreOffice_adapt is \code{TRUE}.}

\item{other_h_style}{This is the formatting applied to any other
h elements not included to the first. Note: this is only applied
if LibreOffice_adapt is \code{TRUE}.}

\item{remove_scripts}{\code{TRUE} if <script></script> tags are
to be removed. These are usually not compatible with Word-processors
and should therefore in most cases be stripped from the document.}

\item{force_captions}{Since out.width and out.height remove the option of
having captions this allows a workaround through some processing
via the XML-package}

\item{css_max_width}{The max width of the body element. Defaults to "40em"
if not specified. Any CSS-compliant width format works.}
}
\value{
R Markdown output format to pass to \code{\link[rmarkdown]{render}}
}
\description{
This function adds the option of having adaptations needed for seemless integration with
MS Word for importing html-documents in the .docx-format. The advantage of html documents is
the ability to create advanced formatting frequently needed in medical publications
and that is available in the \code{\link[htmlTable]{htmlTable}} function. You can view
\href{http://gforge.se/2014-07/fast-track-publishing-using-rmarkdown}{the series}
for more details regarding how to achieve
fast-track-publishing (ftp) together with knitr.
}
\details{
If you want to get equations into Word the currently best way is to
use the \code{\link[rmarkdown]{word_document}} format.
}
\examples{
# Possible yaml configuration at the top of the Rmd doc
\dontrun{
---
title: "Test"
author: "Max Gordon"
output:
  Gmisc::docx_document
---
}
}
\author{
Max Gordon
}
