% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_kw.r
\name{kwPlot}
\alias{kwPlot}
\title{R function for visually displaying Kruskal-Wallis test's results}
\usage{
kwPlot(x, y, strip = FALSE, notch = FALSE, omm = FALSE,
  outl = TRUE, posthoc = FALSE, adjust = "bonferroni")
}
\arguments{
\item{x}{Object storing the values to be analysed.}

\item{y}{Object storing a grouping variable with 3 or more levels.}

\item{strip}{Logical value which takes FALSE (by default) or TRUE if the user wants jittered
points to represent individual values.}

\item{notch}{Logical value which takes FALSE (by default) or TRUE if user does not or do want to
have notched boxplots in the final display, respectively; it is worth noting that overlapping
of notches indicates a not significant difference at about 95 percent confidence.}

\item{omm}{It stands for overall mean and median; takes FALSE (by default) or TRUE if user
wants the mean and median of the overall sample plotted in the chart (as a dashed RED line and
dotted BLUE line respectively).}

\item{outl}{Logical value which takes FALSE or TRUE (by default) if users want the boxplots to
display outlying values.}

\item{posthoc}{Logical value which takes FALSE (default) or TRUE if user does not or does want
to perform a follow-up test (namely, the Dunn's test) in order to locate which group
significantly differs from the others.}

\item{adjust}{Sets the desidered method for p-values adjustment in the context of the Dunn's
test; the list of methods is the following: Bonferroni ("bonferroni"; default); Holm ("holm"),
Hochberg ("hochberg"), Hommel ("hommel"), Benjamini & Hochberg ("BH" or its alias "fdr"),
Benjamini & Yekutieli ("BY"),  none ("none"). For more info, see the 'p.adjust' help
documentation in R (?p.adjust).}
}
\description{
The function  allows allows to perform Kruskal-Wallis test, and to display the test's results in
a plot along with boxplots.
}
\details{
The boxplots display the distribution of the values of the two
samples, and jittered points represent the individual observations. At the bottom of the chart,
the test statistics (H) is reported, along with the degrees of freedom and the associated p
value.\cr Setting the parameter 'posthoc' to TRUE, the Dunn's test is performed (with Bonferroni
adjustment by default): a dot chart is returned, as well as a list of p-values (2-sided). In the
dot chart, a RED line indicates the 0.05 threshold. The groups compared on a pairwise basis are
indicated on the left-hand side of the chart.
}
\examples{
#create a toy dataset
mydata <- data.frame(values=c(rnorm(30, 100,10),rnorm(30, 80,10),rnorm(30, 98,10)),
group = as.factor(gl(3, 30, labels = c("A", "B", "C"))))

# performs the test, displays the test's result, including jittered points and notches.
# It also performs the Dunn's posthoc test using Bonferroni p-value correction.
kwPlot(x=mydata$values, y=mydata$group, strip=TRUE, notch=TRUE, posthoc=TRUE)

}
\seealso{
\code{\link[stats]{p.adjust}}
}
\keyword{kwPlot}
