% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distRandSign.R
\name{distRandSign}
\alias{distRandSign}
\title{R function to test for a significant spatial association between two features (points-to-points,
points-to-lines, points-to-polygons)}
\usage{
distRandSign(from.feat, to.feat, studyplot = NULL, buffer = 0,
  B = 199, oneplot = TRUE)
}
\arguments{
\item{from.feat}{Feature (of point type; SpatialPointsDataFrame class) whose spatial association
with the to-feature has to be assessed.}

\item{to.feat}{Feature (point, polyline, or polygon type; SpatialPointsDataFrame,
SpatialLinesDataFrame, SpatialPolygonsDataFrame class) in relation to which the spatial
association of the from-feature has to be assessed.}

\item{studyplot}{Feature (of polygon type; SpatialPolygonsDataFrame class) representing the
study area; if not provided, the study area is internally worked out as the bounding polygon
based on the union the convex hulls of the from- and of the to-feature.}

\item{buffer}{Add a buffer to the convex hull of the study area (0 by default); the unit depends
upon the units of the input data.}

\item{B}{Number of randomizations to be used (199 by default).}

\item{oneplot}{TRUE (default) or FALSE if the user wants or does not want the plots displayed in
a single window.}
}
\value{
The function returns a list storing the following components \itemize{
 \item{$from.feat.min.dist: }{distance of each entity of the from-feature to the nearest entity
 of the to-feature}
 \item{$avrg.obs.min.dist: }{observed average minimum distance}
 \item{$avrg.rnd.min.dist: }{average randomized minimum distance}
 \item{$avrg.perm.min.dist: }{average permuted minimum distance (returned only when both the
 from- and to- features are of point type)}
 \item{$p.value closer than expected-rnd- }
 \item{$p.value closer than expected-perm- (returned only when both the from- and to-
 features are of point type)}
 \item{$p.value more distant than expected-rnd- }
 \item{$p.value more distant than expected-perm- (returned only when both the from- and to-
 features are of point type)}
 \item{$p.value different from random-rnd-: }
 \item{$p.value different from random-perm- (returned only when both the from- and to-
 features are of point type)}
}
}
\description{
The function allows to assess if there is a significant spatial association between a point
pattern and the features of another pattern. For instance, users may want to assess if some
locations tend to lie close to some features represented by polylines. By the same token, users
may want to know if there is a spatial association between the location of a given event and the
location of another event. See the example provided further below (in the examples section),
where the question to address is if there is a spatial association between springs and geological
fault-lines; in other words: do springs tend to be located near the geological faults?\cr
}
\details{
Given a from-feature (event for which we want to estimate the spatial association with the
to-feature) and a to-feature (event in relation to which we want to estimate the spatial
association for the from-feature), the assessment is performed by means of a randomized
procedure:\cr

-keeping fixed the location of the to-feature, random from-features are drawn B times (the number
of randomized from-features is equal to the number of observed from-features);\cr -for each draw,
the average minimum distance to the to-features is calculated; if the to-feature is made up of
polygons, the from-features falling within a polygon will have a distance of 0;\cr -a
distribution of average minimum distances is thus obtained;\cr -p values are computed following
Baddeley et al., "Spatial Point Patterns. Methodology and Applications with R", CRC Press 2016,
p. 387.\cr

The from-feature must be a point feature, whilst the to-feature can be a point or a polyline or a
polygon feature.\cr

The rationale of the procedure is that, if there indeed is a spatial association between the two
features, the from-feature should be on average closer to the to-feature than randomly generated
from-features. If the studyplot shapefile is not provided, the random locations are drawn within
a bounding polygon based on the union the convex hulls of the from- and of the to-feature.\cr

If both the from-feature and the to-feature are of point type (SpatialPointsDataFrame class), the
function also test the spatial association by means of a permuted procedures. Unlike the
procedure described above, whereby random points are drawn within the study area, the
permutation-based routine builds a distribution of averages minimum distances keeping the points
location unchanged and randomly assigning the points to either of the two patterns. The
re-assignment is performed B times (199 by default) and each time the average minimum distance is
calculated.\cr

The function produces a histogram showing: the distribution of randomized average minimum
distances; a black dot indicating the observed average minimum distance; a hollow dot
representing the average of the randomized minimum distances; two blue reference lines correspond
to the 0.025th and to the 0.975th quantile of the randomized distribution. P-values are reported
at the bottom of the plot.\cr

In case both the from- and the to- feature are of point type, another histogram is produced,
which provides the same information of the preceding histogram, but derived from the
permutation-based routine that has been detailed above.
}
\examples{
data(springs)
data(faults)

#calculate the significance of the spatial association between springs and geological
#fault-lines; plots displayed in a single panel
result <- distRandSign(from.feat=springs, to.feat=faults, oneplot=TRUE, B=49)

data(points)
data(polygons)

#calculate the significance of the spatial association between points and polygons
result <- distRandSign(from.feat=points, to.feat=polygons, oneplot=FALSE, B=49)

}
\seealso{
\code{\link{distRandCum}} , \code{\link{distCovarModel}} , \code{\link{Aindex}}
}
\keyword{distRandSign}
