% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Geodesic.R
\name{geodesic}
\alias{geodesic}
\title{To convert from Cartesian coordinate to Geographic coordinate.}
\usage{
geodesic(a, XYZ_df, digits = 4)
}
\arguments{
\item{a}{Selection of Ellipsoid.}

\item{XYZ_df}{Sexagesimal longitude and latitude as dataframe.}

\item{digits}{Number of digits the seconds are \code{\link{round}ed} to. DEFAULT: 4}
}
\value{
data.frame with the data in the following order: "Pt", "Lat", "Lon", "H".
}
\description{
With this function it is possible to convert from Cartesian coordinate to Geographic coordinate and obtain the decimal precision that you assign.
}
\note{
create data frame of epsg codes by epsg <- rgdal::make_EPSG()
}
\examples{
# Point name
Pto <- "St1"

# Cartesian data
X <- 1711591.78090565
Y <- -5060304.1659587
Z <- -3473256.69328603

# Pto, X, Y and Z as data.frame
XYZ_df <- as.data.frame(cbind(Pto, X, Y, Z))

# To know the ellipsoids and the order open the Ellipsoids in the package and look for it number
Ellip <- Ellipsoids
#View(Ellip)

# We choose the number 5 which is GRS80
value <- geodesic(5, XYZ_df, digits = 4)
print(value)
}
\references{
https://github.com/OSGeo/PROJ & https://github.com/cran/rgdal
}
