% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPred.R
\name{plotPred}
\alias{plotPred}
\title{Plots the predictions and the corresponding uncertainty (coefficient of
variation)}
\usage{
plotPred(
  pred = NULL,
  predRaster = NULL,
  admin0 = NULL,
  admin1 = NULL,
  admin2 = NULL,
  rmPoly = NULL,
  target_crs = NULL
)
}
\arguments{
\item{pred}{A matrix that is the output of predRes() function.}

\item{predRaster}{The prediction raster that is constructed by the
gridCountry() function.}

\item{admin0}{An sf class MULTIPOLYGON representing the national level (admin0)
borders of the country.}

\item{admin1}{An sf class MULTIPOLYGON representing the first level (admin1)
subnational borders of the country.}

\item{admin2}{An sf class MULTIPOLYGON representing the second level (admin2)
subnational borders of the country.}

\item{rmPoly}{A number referring to the ID number of the admin2 level polygon
that needs to be left uncolored. It can be set to NULL as well.}

\item{target_crs}{A projection string representing the desired coordinate
reference system according to which the maps will be created.}
}
\value{
A list of two ggplot objects. One of them (ggPred) shows the median
predictions and the other one (ggUncertainty) shows the
corresponding coefficient of variations across the country, respectively.
}
\description{
Plots the predictions and the corresponding uncertainty (coefficient of
variation)
}
\examples{
\donttest{
path1 <- system.file("extdata", "examplePredictionResults.rda", package = "GeoAdjust")
path2 <- system.file("extdata", "geoData.rda", package = "GeoAdjust")
load(path1)
load(path2)
crs_KM = "+units=km +proj=utm +zone=37 +ellps=clrk80 +towgs84=-160,-6,-302,0,0,0,0 +no_defs"
exampleGrid <- gridCountry(admin0 = adm0, res = 5, target_crs = crs_KM)
plots = plotPred(pred = examplePredictionResults,
predRaster = exampleGrid[["predRast"]], admin0 = adm0,
admin1 = adm1, target_crs = crs_KM)
}
}
