% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predRes.R
\name{predRes}
\alias{predRes}
\title{Predicts model outcomes at new locations.}
\usage{
predRes(
  obj = NULL,
  predCoords = NULL,
  draws = NULL,
  nCov = NULL,
  covariateData = NULL,
  mesh.s = NULL,
  flag = NULL
)
}
\arguments{
\item{obj}{The optimized core model object returned by estimateModel() function.}

\item{predCoords}{A matrix containing the coordinates of the prediction locations in kilometers (UTM zone:37).}

\item{draws}{A matrix containing 10.000 sampled values for each covariate effect size and 10.000 sampled values of random effect coefficients for each mesh node.
It is one of the elements of the returning output list of estimateModel() function.}

\item{nCov}{A value showing the number of covariates (including the intercept).}

\item{covariateData}{A list containing the covariate rasters.}

\item{mesh.s}{A mesh created based on the country borders.}

\item{flag}{A value indicating the type of the likelihood that will be used. Pass 0 for Gaussian, 1 for binomial and 2 for Poisson likelihoods.}
}
\value{
A matrix containing the mean, median,standard deviation and the lower and the upper bounds of 95% credible intervals of the predictions.
}
\description{
Predicts model outcomes at new locations.
}
\examples{
\donttest{
if(requireNamespace("INLA")){
path1 <- system.file("extdata", "exampleInputData.rda", package = "GeoAdjust")
path2 <- system.file("extdata", "exampleMesh.rda", package = "GeoAdjust")
path3 <- system.file("extdata", "exampleGrid.rda", package = "GeoAdjust")
load(path1)
load(path2)
load(path3)
nNodes = exampleMesh[['n']]
results <- estimateModel(data = exampleInputData, nNodes = nNodes,
options = list(random = 1, covariates = 1), priors = list(beta = c(0,1),
range = 114, USpatial = 1, alphaSpatial = 0.05, UNugget = 1, alphaNug = 0.05))
pred = predRes(obj = results[["obj"]],
predCoords = cbind(exampleGrid[["loc.pred"]]["east"],
exampleGrid[["loc.pred"]]["north"]),
draws = results[["draws"]], nCov = 1,
mesh.s = exampleMesh, covariateData = NULL, flag = 1)
}
}
}
