% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{calculate_permutation_feature_importance}
\alias{calculate_permutation_feature_importance}
\title{Calculate Permutation Feature Importance}
\usage{
calculate_permutation_feature_importance(
  pipeline,
  X_train,
  y_train,
  n_repeats = 10L,
  random_state = 0L,
  njobs = njobs,
  pipeline_name,
  iter
)
}
\arguments{
\item{pipeline}{A Scikit-learn pipeline object with a trained classifier as the final step.}

\item{X_train}{A DataFrame containing the training data.}

\item{y_train}{A DataFrame containing the training labels.}

\item{n_repeats}{An integer specifying the number of times to permute each feature.}

\item{random_state}{An integer specifying the seed for the random number generator.}

\item{njobs}{An integer specifying number of cores to use. Set up by the master GeneSelectR function.}

\item{pipeline_name}{Strings (names of the selected_pipelines list) representing pipeline names that were constructed for the feature selection}

\item{iter}{An integer that is indicating current iteration of the train-test split}
}
\value{
A dataframe containing the feature names and their permutation importance scores, ranked by importance.
Each row represents a feature, with columns for feature names, importances, and ranks.
}
\description{
This function calculates permutation feature importance for a Scikit-learn
pipeline with a trained classifier as the final step.
}
