% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{getSizeMean}
\alias{getSizeMean}
\title{General Formulas for Sample Size Calculation}
\usage{
getSizeMean(
  design = c("parallel", "crossover"),
  test = c("equality", "noninferiority", "superiority", "equivalence"),
  alpha = 0.05,
  beta = 0.2,
  sigma,
  k = 1,
  delta = 0,
  TTE,
  rho = c(0.05, 0.07),
  r = 0.1
)
}
\arguments{
\item{design}{allocation method (\code{parallel} or \code{crossover}).}

\item{test}{four hypothesis tests: \code{equality}, \code{noninferiority}, \code{superiority}, and \code{equivalence}.}

\item{alpha}{level of significance.}

\item{beta}{type II error.}

\item{sigma}{pooled standard deviation of two groups.}

\item{k}{ratio of control to treatment.}

\item{delta}{delta margin in test hypothesis.}

\item{TTE}{target treatment effect or effect size.}

\item{rho}{vector of length 2, positive noncompliance rates of two arms.}

\item{r}{projected proportion of trial uniform loss of follow-up.}
}
\value{
sample size per arm.
}
\description{
This function computes the sample size required for two arms clinical trials with continuous outcome measure. Four hypothesis tests are available under two allocation designs.
}
\examples{
# Ex 1. (n_trt=91, n_ctl=91)
getSizeMean(design="parallel", test="equality", alpha=0.05, beta=0.20,
  sigma=0.10, k=1, delta=0, TTE=0.05, rho=c(0.05, 0.07), r=0.1)

getSizeMean(design="parallel", test="noninferiority", alpha=0.05,
 beta=0.20, sigma=0.10, k=1, delta=-0.05, TTE=0, rho=c(0.05, 0.07), r=0.1)

# Ex 3. (n_trt=1022, n_ctl=1022)
getSizeMean(design="parallel", test="superiority", alpha=0.05, beta=0.20,
  sigma=0.10, k=1, delta=0.05, TTE=0.07, rho=c(0.05, 0.07), r=0.1)

# Ex 4. (n_trt=113, n_ctl=113)
getSizeMean(design="parallel", test="equivalence", alpha=0.05, beta=0.20,
  sigma=0.10, k=1, delta=0.05, TTE=0.01, rho=c(0.05, 0.07), r=0.1)

# Ex 5. (n_trt=23, n_ctl=23)
getSizeMean(design="crossover", test="equality", alpha=0.05, beta=0.20,
 sigma=0.10, k=1, delta=0, TTE=0.05, rho=c(0.05, 0.07), r=0.1)

# Ex 6. (n_trt=14, n_ctl=14)
getSizeMean(design="crossover", test="noninferiority", alpha=0.05,
 beta=0.20, sigma=0.10, k=1, delta=-0.05, TTE=0, rho=c(0.05, 0.07), r=0.1)

# Ex 7. (n_trt=21, n_ctl=21)
getSizeMean(design="crossover", test="superiority", alpha=0.05, beta=0.20,
 sigma=0.10, k=1, delta=0.05, TTE=0.01, rho=c(0.05, 0.07), r=0.1)

# Ex 8. (n_trt=29, n_ctl=29)
getSizeMean(design="crossover", test="equivalence", alpha=0.05, beta=0.20,
 sigma=0.10, k=1, delta=0.05, TTE=0.01, rho=c(0.05, 0.07), r=0.1)

}
