% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{solar_PV}
\alias{solar_PV}
\title{Photovoltaic Example Dataset}
\format{
\code{solar_PV} is a list with 5 elements:
\describe{
  \item{\code{SE}}{Searcher efficiency trial data}
  \item{\code{CP}}{Carcass persistence trial data}
  \item{\code{SS}}{Search schedule parameters}
  \item{\code{DWP}}{Density weighted proportion of area searched}
  \item{\code{CO}}{Carcass observations}
}
}
\source{
\code{solar_PV}
}
\usage{
solar_PV
}
\description{
An example data set for estimating fatalities from a large photovoltaic solar
 generation facility.
 
The simulated site is organized into 300 arrays of panels.  As observers walk
 north-south along paths between arrays, they look east or west down rows 
 between solar panels 150 meters long, with 38 searchable rows per array.  
 Observers consistently look for animals down one cardinal direction, making 
 this a one-sided distance sample.  Searches are scheduled on a seven day
 rotation, with 60 arrays searched per weekday.  A sitewide clearout search 
 is implemented before the first scheduled winter search.
 
The dataset consists of five parts: Data on carcass observations (CO) from 
array searches, field trials for estimating carcass persistence (CP) and 
searcher efficiency (SE), search schedule (SS), and density weighted 
proportion (DWP) of area searched at each array (which is an area adjustment 
factor to account for incomplete search coverage).
}
\section{Searcher Efficiency (\code{SE})}{

 \code{$SE} is a data frame with each row representing the fate of a single
 carcass in the searcher efficiency trials. There are columns for:
\describe{
  \item{\code{Season}}{\code{"winter"}, \code{"spring"}, \code{"summer"}, or 
  \code{"fall"}}
  \item{\code{Size}}{\code{"bat"}; or \code{"lrg"}, \code{"med"}, or
    \code{"sml"} bird}
  \item{\code{"Search1",...,"Search5"}}{fate of carcass on the 1st, 2nd, 3rd,
   4th, and 5th search after placement. A value of 1 implies that a carcass 
   was discovered by searchers, 0 implies the carcass was present but not
     discovered, and any other value is interpreted as "no search" or
     "carcass not present" and ignored in the model. In this data set,
     \code{NA} indicates that a carcass had been previously discovered and
     removed from the field. A user may use a variety of values to
     differentiate different reasons no search was conducted or the carcass
     was not present. For example, "NS" to indicate the search
     was not scheduled in that location at that time, or "SC" to indicate the
     carcass had been removed by scavengers prior to the search.}
  \item{\code{Distance}}{the distance a carcass was placed from the 
  observer's transect. Used in determining probability to detect with 
  distance sampling.}
}
}

\section{Carcass Persistence (\code{CP})}{

 \code{$CP} is a data frame with each row representing the fate of a single
 carcass in the carcass persistence trials. There are columns for:
\describe{
  \item{\code{Index}}{unique ID for each carcass}
  \item{\code{Season}}{\code{"winter"}, \code{"spring"}, \code{"summer"}, or 
  \code{"fall"}}
  \item{\code{Size}}{\code{"bat"}; or \code{"lrg"}, \code{"med"}, or
   \code{"sml"} bird}
  \item{\code{LastPresent}, \code{FirstAbsent}}{endpoints of the interval bracketing
   the time the carcass was scavenged or otherwise removed from the field.
   For example, \code{LastPresent = 2.04}, \code{FirstAbsent = 3.21} indicates that the
   carcass was last observed 2.04 days after being placed in the field and
   was noted missing 3.21 days after being placed. If the precise time of
   carcass removal is known (e.g., recorded by camera), then \code{LastPresent} and
   \code{FirstAbsent} should be set equal to each other. If a carcass persists
   beyond the last day of the field trial, \code{LastPresent} is the last time it
   was observed and \code{FirstAbsent} is entered as \code{Inf} or \code{NA}.}
}
}

\section{Search Schedule (\code{SS})}{

 \code{$SS} is a data frame with a row for each date an array at the site was
  searched, a column of \code{SearchDate}s, and a column for each array. In 
  addition, there is an optional column to indicate the \code{Season}. The 
  columns for distinct area (array) and the date column are required, and the
  names of the columns for search areas must match the names of areas used in 
  the DWP and CO files.
\describe{
  \item{\code{SearchDate}}{columns of dates when arrays were searched. Format
   in this data is \code{"\%Y-\%m-\%d CDT"}, but time zone (\code{CDT}) is 
   optional. A time stamp may be included if desired (e.g., 
   \code{2018-03-20 02:15:41}). Alternatively, \code{\\} can be used in
   place of \code{-}.}
  \item{\code{Season}}{\code{"winter"}, \code{"spring"}, \code{"summer"},
   or \code{"fall"} to indicate which season the search was conducted in. 
   \code{Season} is optional but may be used as a temporal covariate for 
   fatality estimates.}
}
}

\section{Density Weighted Proportion (\code{DWP})}{

 \code{$DWP} is a data frame with a row for each array and columns for each 
 carcass size class (labels must match those of the class factors in the 
 carcass observation file). Values represent the density-weighted proportion 
 of the searched area for each size (or the fraction of carcasses that fall 
 in the searched area).  In this example, observers walk along transects 
 separated by 150 meters, and search coverage is assumed to be 100%, i.e.,
 DWP = 1 for each unit. This requires that carcasses be placed at random
 locations in the field, even at distances from the transects that would make
 it unlikely to observe small carcasses.
\describe{
  \item{\code{Unit}}{unique ID for each array.  IDs match those used in the 
  \code{$CO} data frame and the column names in the \code{$SS} data.}
  \item{\code{bat}}{DWP associated with size class Bat}
  \item{\code{sml}}{DWP associated with size class Small}
  \item{\code{med}}{DWP associated with size class Medium}
  \item{\code{lrg}}{DWP associated with size class Large}
}
}

\section{Carcass Observations (\code{CO})}{

\code{$CO} is a data frame with a row for carcass observed in the carcass
  searches and a number of columns giving information about the given
  carcass (date found, size, species, etc.)
\describe{
  \item{\code{Index}}{unique identifier for each carcass.}
  \item{\code{Unit}}{identifier for which unit the given carcass was found 
  at: \code{"arc19"}, \code{"arc65"}, etc, for arcs in the outer heliostat 
  field, or \code{"center"}, indicating the inner heliostat field.}
  \item{\code{Species}}{species of the carcass: \code{"BA"}, \code{"BB"},
    \code{"BC"}, \code{"BD"}, \code{"BE"}, \code{"LA"}, \code{"LB"},
    \code{"LD"}, \code{"LE"}, \code{"MA"}, \code{"MB"}, \code{"SA"},
    \code{"SB"}, \code{"SC"}, \code{"SD"}, \code{"SE"}, \code{"SF"},
    \code{"SG"}}
  \item{\code{Size}}{size: \code{"bat"}, \code{"lrg"}, \code{"med"},
   \code{"sml"}}
  \item{\code{Row}}{Optional indicator of which row within an array a carcass
   was found at.}
  \item{\code{Distance}}{The perpendicular distance from the searcher's 
  transect at which the carcass was discovered at.}
  \item{\code{DateFound}}{dates entered in the same format as in 
  \code{$SS$SearchDate}. Every date entered here is (and must be) included in
   the search schedule 
  (\code{$SS$SearchDate}}
  \item{\code{X}}{UTM Easting of carcass.}
  \item{\code{Y}}{UTM Northing of carcass.}
}
}

\keyword{datasets}
