% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app_ui.R
\name{GenEstUI}
\alias{GenEstUI}
\alias{dataInputPanel}
\alias{dataInputSidebar}
\alias{loadedDataPanel}
\alias{analysisPanel}
\alias{GeneralInputsPanel}
\alias{GeneralInputSidebar}
\alias{SEPanel}
\alias{SESidebar}
\alias{SEMainPanel}
\alias{CPPanel}
\alias{CPSidebar}
\alias{CPMainPanel}
\alias{MPanel}
\alias{MSidebar}
\alias{MMainPanel}
\alias{gPanel}
\alias{gSidebar}
\alias{gMainPanel}
\alias{helpPanel}
\alias{gettingStartedPanel}
\alias{downloadsPanel}
\alias{aboutPanel}
\alias{disclaimersPanel}
\title{Create the GenEst User Interface HTML}
\usage{
GenEstUI(appType = "base")

dataInputPanel()

dataInputSidebar()

loadedDataPanel()

analysisPanel()

GeneralInputsPanel()

GeneralInputSidebar()

SEPanel()

SESidebar()

SEMainPanel()

CPPanel()

CPSidebar()

CPMainPanel()

MPanel()

MSidebar()

MMainPanel()

gPanel()

gSidebar()

gMainPanel()

helpPanel(appType = "base")

gettingStartedPanel()

downloadsPanel()

aboutPanel()

disclaimersPanel(appType = "base")
}
\arguments{
\item{appType}{Toggle control for the app, \code{"base"} for local versions
or \code{"deploy"} for hosted version. Currently only differentiates the
disclaimer text.}
}
\value{
Each function returns a string of HTML code, either as a
  \code{"shiny.tag.list"} object (in the case of \code{GenEstUI}) or a
  \code{"shiny.tag"} object (in the case of the other functions). \cr \cr 
  \code{GenEstUI}: Full GenEst user interface.

\code{dataInputPanel}: Data Input panel.

\code{dataInputSidebar}: Data Input sidebar.

\code{loadedDataPanel}: Data Input data panel.

\code{AnalysisPanel}: Analysis panel.

\code{GeneralInputsPanel}: Analysis -> General Inputs panel.

\code{GeneralInputSidebar}: Analysis -> General Inputs sidebar.

\code{SEPanel}: Analysis -> Searcher Efficiency panel.

\code{SESidebar}: Analysis -> Searcher Efficiency sidebar.

\code{SEMainPanel}: Analysis -> Searcher Efficiency main panel.

\code{CPPanel}: Analysis -> Carcass Persistence panel.

\code{CPSidebar}: Analysis -> Carcass Persistence sidebar.

\code{CPMainPanel}: Analysis -> Carcass Persistence main panel.

\code{MPanel}: Analysis -> Mortality Estimation panel.

\code{MSidebar}: Analysis -> Mortality Estimation 
  sidebar.

\code{MMainPanel}: Analysis -> Mortality Estimation main panel.

\code{gPanel}: Analysis -> Detection Probability panel.

\code{gSidebar}: Analysis -> Detection Probability sidebar.

\code{gMainPanel}: Analysis -> Detection Probability main panel.

\code{helpPanel}: Help panel.

\code{gettingStartedPanel}: Help -> Getting Started panel.

\code{downloadsPanel}: Help -> Downloads panel.

\code{aboutPanel}: Help -> About panel.

\code{aboutPanel}: Help -> Disclaimers panel.
}
\description{
This suite of functions create the HTML code underlying the
  GenEst user interface (UI). See the "GenEst Graphic User Interface"
  vignette for a more complete detailing of the codebase underlying
  the GenEst UI. \cr \cr \code{GenEstUI}: whole application. Calls 
  \code{dataInputPanel}, \code{analysisPanel}, and \code{helpPanel}.

\code{dataInputPanel}: Data Input panel. Calls 
  \code{dataInputSidebar} and \code{loadedDataPanel}.

\code{dataInputSidebar}: Data Input panel's sidebar (where the
  data files are selected). Calls \code{\link{dataInputWidget}} for each 
  data file type.

\code{loadedDataPanel}: Data Input panel's main page (where 
  the data files are displayed). Calls \code{\link{dataTabPanel}} for each 
  data file type.

\code{analysisPanel}: Analysis panel. Calls
  \code{GeneralInputsPanel}, \code{SEPanel}, \code{CPPanel}, 
  \code{MPanel}, and \code{gPanel}.

\code{GeneralInputsPanel}: Analysis panel's General Inputs 
  panel. Calls \code{GeneralInputSidebar}.

\code{GeneralInputSidebar}: 
  Analysis panel's General Inputs sidebar (where the Number of Iterations,
  Confidence Level, and Size Class Column are selected). Calls 
  \code{\link{modelInputWidget}} for each input.

\code{SEPanel}: Analysis panel's Searcher Efficiency panel.
  Calls \code{SESidebar} and \code{SEMainPanel}.

\code{SESidebar}: Analysis panel's Searcher Efficiency panel's
  sidebar (where the Observation Columns, Predictor Columns, and fixed-k 
  values are input and where the Size Class, p formula, and k formula are 
  selected for the outputs). Calls \code{\link{modelInputWidget}} for each 
  input, \code{\link{modelRunWidget}} for running the model button, and 
  \code{\link{modelOutputWidget}} for output controls.

\code{SEMainPanel}: Analysis panel's Searcher Efficiency 
  panel's main panel (where the Selected Data, Model Comparison, Figures,
   Model Estimates, and Model Selection are displayed). Calls
  \code{selectedDataPanel} for the selected data and then 
   \code{modelOutputPanel} for each output.

\code{CPPanel}: Analysis panel's Carcass Persistence panel. 
  Calls \code{CPSidebar} and \code{CPMainPanel}.

\code{CPSidebar}: Analysis panel's Carcass Persistence
  panel's sidebar (where the Observation Columns, Predictor Columns, and
  Distributions are input and where the Size Class, location formula,
  and scale formula are selected for the outputs). Calls
  \code{\link{modelInputWidget}} for each input, 
  \code{\link{modelRunWidget}} for running the model button, and 
  \code{\link{modelOutputWidget}} for the output controls.

\code{CPMainPanel}: Analysis panel's Carcass Persistence
  panel's main panel (where the Selected Data, Model Estimates, Model
  Comparison, Figures, and Model Selection are displayed). Calls
  \code{selectedDataPanel} for the selected data and 
  \code{modelOutputPanel} for each of the outputs.

\code{MPanel}: Analysis panel's Mortality Estimation panel. 
  Calls \code{MSidebar} and \code{MMainPanel}.

\code{MSidebar}: Analysis panel's Mortality Estimation panel's
  sidebar (where the assummed k (if needed), Fraction of Facility Sampled,
  DWP Column, and Date Found Column are input and the Size Class is
  selected for the outputs). Calls 
  \code{\link{modelInputWidget}} for each input,
  \code{\link{modelRunWidget}} for running the model button, and 
  \code{\link{modelOutputWidget}} for the output controls.

\code{MMainPanel}: Analysis panel's Mortality Estimation 
  panel's main panel (where Figures, and Summary are displayed). Calls 
  \code{modelOutputPanel} for each output.

\code{gPanel}: Analysis panel's Detection Probability panel. 
  Calls \code{gSidebar} and \code{gMainPanel}.

\code{gSidebar}: Analysis panel's Detection Probability 
  panel's sidebar (where the Search Schedule and assummed k (if needed) are
  input and the Size Class, is selected for the outputs). Calls 
  \code{\link{modelInputWidget}} for each input, 
  \code{\link{modelRunWidget}} for running the model button, and 
  \code{\link{modelOutputWidget}} for the output controls.

\code{gMainPanel}: Analysis panel's Detection Probability 
  panel's main panel (where the Search Schedule, Figures, and Summary are 
  displayed). Calls \code{modelOutputPanel} for each output.

\code{helpPanel}: Help panel. Calls 
  \code{gettingStartedPanel}, \code{downloadsPanel}, \code{aboutPanel}, 
  and \code{disclaimersPanel}.

\code{gettingStartedPanel}: Help panel's Getting Started 
  panel. calls \code{\link{gettingStartedContent}}, the function containing
  the raw content for the page (which is text heavy and so moved to its own 
  function).

\code{downloadsPanel}: Help panel's Example Data panel. Calls
  \code{\link{dataDownloadWidget}} for each data set.

\code{aboutPanel}: Help panel's About panel. Calls 
  \code{\link{aboutContent}}, the function containing the raw
  content for the page (which is text heavy and so moved to its own 
  function).

\code{disclaimersPanel}: Help panel's Disclaimers panel. 
  Calls \code{\link{disclaimersContent}}, the function containing the raw
  content for the page (which is text heavy and so moved to its own 
  function).
}
\details{
Currently there are few differences between the local and deployed
  versions of GenEst, and the \code{appType} toggle is only included as an 
  argument for functions that can produce different versions of the HTML.
  At this point, the only content that is different is the disclaimer text
  on the Help panel.
}
