% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn.graph.R
\name{knn.graph}
\alias{knn.graph}
\title{Saturated or K Nearest Neighbour Graph}
\usage{
knn.graph(x, row.names = NULL, k = NULL, max.dist = NULL, sym = FALSE,
  long.lat = FALSE, drop.diag = FALSE)
}
\arguments{
\item{x}{sp SpatialPointsDataFrame object}

\item{row.names}{Unique row.names assigned to results}

\item{k}{K nearest neighbours}

\item{max.dist}{Maximum length of an edge (used for distance constraint)}

\item{sym}{Create symmetrical graph (FALSE/TRUE)}

\item{long.lat}{Coordinates are longitude-latitude decimal degrees (FALSE/TRUE), in which case distances are measured in kilometers}

\item{drop.diag}{Drop diag (duplicate edges) (FALSE/TRUE)}
}
\value{
SpatialLinesDataFrame object with:
   i        Name of column in x with FROM (origin) index
   j        Name of column in x with TO (destination) index
   from_ID     Name of column in x with FROM (origin) region ID
   to_ID     Name of column in x with TO (destination) region ID
   length   Length of each edge (line) in projection units or kilometers if long.lat = TRUE
}
\description{
Creates a kNN or saturated graph SpatialLinesDataFrame object
}
\note{
...
}
\examples{
 library(sp) 
   data(ralu.site)

 # Saturated spatial graph
 sat.graph <- knn.graph(ralu.site, row.names=ralu.site@data[,"SiteName"])
  head(sat.graph@data)
 
 # Distanced constrained spatial graph
 dist.graph <- knn.graph(ralu.site, row.names=ralu.site@data[,"SiteName"], max.dist = 5000)

 par(mfrow=c(1,2))	
plot(sat.graph, col="grey")
  points(ralu.site, col="red", pch=20, cex=1.5)
     box()
     title("Saturated graph")	
plot(dist.graph, col="grey")
  points(ralu.site, col="red", pch=20, cex=1.5)
     box()
     title("Distance constrained graph")	  
	
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org> and Melanie Murphy <melanie.murphy@uwyo.edu>
}
\references{
Murphy, M. A. & J.S. Evans. (in prep). "GenNetIt: gravity analysis in R for landscape genetics" 
Murphy M.A., R. Dezzani, D.S. Pilliod & A.S. Storfer (2010) Landscape genetics of high mountain frog metapopulations. Molecular Ecology 19(17):3634-3649
}

