% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3methods.R, R/S3methods_GeDSboost-GeDSgam.R
\name{formula.GeDS}
\alias{formula.GeDS}
\alias{formula.GeDSboost}
\alias{formula.GeDSgam}
\title{Formula for the predictor model}
\usage{
\method{formula}{GeDS}(x, ...)

\method{formula}{GeDSboost}(x, ...)

\method{formula}{GeDSgam}(x, ...)
}
\arguments{
\item{x}{fitted \code{\link{GeDS-class}} object, produced by 
\code{\link{NGeDS}} or \code{\link{GGeDS}}, from which the predictor model
\code{\link[stats]{formula}} should be extracted.}

\item{...}{unused in this case.}
}
\description{
A description of the structure of the predictor model fitted using
\code{\link{NGeDS}} or \code{\link{GGeDS}}.
}
\details{
In GeDS GNM (GLM) regression, implemented with \code{\link{NGeDS}} and
\code{\link{GGeDS}}, the mean of the response variable, correspondingly
transformed through an appropriate link function, is modeled using a
potentially multivariate predictor model. The latter comprises two components:
a GeD variable-knot spline regression involving up to two of the independent
variables, and a parametric component for the remaining independent variables.
The formula defines the structure of this potentially multivariate predictor.

The formulae that are input in \code{\link{NGeDS}} and \code{\link{GGeDS}}
are similar to those input in \code{\link[stats]{lm}} or
\code{\link[stats]{glm}} except that the function \code{\link{f}} should be
specified in order to identify which of the covariates enter the GeD spline
regression part of the predictor model. For example, if the predictor model
is univariate and it links the transformed mean of \code{y} to \code{x1},
the predictor has only a GeD spline component and the
\code{\link[stats]{formula}} should be in the form \code{y ~ f(x1)}.

As noted, there may be additional independent variables, \code{x2},
\code{x3}, ... which may enter linearly into the parametric component of the
predictor model and not be part of the GeD spline regression component. For
example one may use the formula \code{y ~ f(x1) + x2 + x3} which assumes a
spline regression only between the transformed mean of \code{y} and \code{x1},
while \code{x2} and \code{x3} enter the predictor model linearly.

Both function \code{\link{NGeDS}} and function \code{\link{GGeDS}}, generate
bivariate GeDS regression models. Therefore, if the functional dependence of
the mean of the response variable \code{y} on \code{x1} and \code{x2} needs
to be jointly modeled and there are no other covariates, the formula for the
corresponding two dimensional predictor model should be specified as
\code{y ~ f(x1,x2)}.

Within the argument \code{formula}, similarly as in other \R functions, it is
possible to specify one or more offset variables, i.e. known terms with fixed
regression coefficients equal to 1. These terms should be identified via the
function \code{\link[stats]{offset}}.

For \code{\link{NGeDSboost}} and \code{\link{NGeDSgam}}, a formula of the form 
\code{y ~ f(x1) + f(x2, x3) + x4} should be provided, where \code{f()} denotes 
GeD spline-based (univariate or bivariate) regression base-learners/smoothing 
functions, and \code{x4} is included as a linear term in the predictor model.
}
