% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{corr_gauss_matrix_armaC}
\alias{corr_gauss_matrix_armaC}
\title{Correlation Gaussian matrix in C using Armadillo}
\usage{
corr_gauss_matrix_armaC(x, y, theta, s2 = 1)
}
\arguments{
\item{x}{Matrix x}

\item{y}{Matrix y, must have same number of columns as x}

\item{theta}{Theta vector}

\item{s2}{Variance to multiply matrix by}
}
\value{
Correlation matrix
}
\description{
20-25% faster than Rcpp version.
}
\examples{
corr_gauss_matrix_armaC(matrix(c(1,0,0,1),2,2),matrix(c(1,0,1,1),2,2),c(1,1))

x1 <- matrix(runif(100*6), nrow=100, ncol=6)
x2 <- matrix(runif(1e4*6), ncol=6)
th <- c(.3,3.3)
t1 <- corr_gauss_matrixC(x1, x2, th)
t2 <- corr_gauss_matrix_armaC(x1, x2, th)
identical(t1, t2)
# microbenchmark::microbenchmark(corr_gauss_matrixC(x1, x2, th),
#                                corr_gauss_matrix_armaC(x1, x2, th))
}
