// Generated by rstantools.  Do not edit by hand.

/*
    GUD is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    GUD is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GUD.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_TPSC_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 46> locations_array__ =
  {" (found before start of program)",
  " (in 'TPSC', line 29, column 2 to column 36)",
  " (in 'TPSC', line 30, column 2 to column 22)",
  " (in 'TPSC', line 31, column 2 to column 22)",
  " (in 'TPSC', line 32, column 2 to column 17)",
  " (in 'TPSC', line 41, column 2 to column 20)",
  " (in 'TPSC', line 42, column 2 to column 18)",
  " (in 'TPSC', line 43, column 2 to column 8)",
  " (in 'TPSC', line 44, column 2 to column 10)",
  " (in 'TPSC', line 45, column 2 to column 10)",
  " (in 'TPSC', line 47, column 6 to column 27)",
  " (in 'TPSC', line 48, column 6 to column 62)",
  " (in 'TPSC', line 49, column 6 to column 61)",
  " (in 'TPSC', line 50, column 6 to column 33)",
  " (in 'TPSC', line 51, column 6 to column 39)",
  " (in 'TPSC', line 52, column 6 to line 56, column 9)",
  " (in 'TPSC', line 46, column 17 to line 57, column 3)",
  " (in 'TPSC', line 46, column 2 to line 57, column 3)",
  " (in 'TPSC', line 35, column 2 to column 19)",
  " (in 'TPSC', line 36, column 2 to column 25)",
  " (in 'TPSC', line 37, column 2 to column 25)",
  " (in 'TPSC', line 38, column 2 to column 65)",
  " (in 'TPSC', line 23, column 2 to column 17)",
  " (in 'TPSC', line 24, column 2 to column 17)",
  " (in 'TPSC', line 25, column 9 to column 10)",
  " (in 'TPSC', line 25, column 2 to column 14)",
  " (in 'TPSC', line 26, column 9 to column 10)",
  " (in 'TPSC', line 26, column 11 to column 12)",
  " (in 'TPSC', line 26, column 2 to column 16)",
  " (in 'TPSC', line 32, column 9 to column 10)",
  " (in 'TPSC', line 41, column 9 to column 10)",
  " (in 'TPSC', line 42, column 9 to column 10)",
  " (in 'TPSC', line 3, column 4 to line 7, column 69)",
  " (in 'TPSC', line 2, column 67 to line 8, column 3)",
  " (in 'TPSC', line 11, column 4 to column 12)",
  " (in 'TPSC', line 12, column 11 to column 12)",
  " (in 'TPSC', line 12, column 4 to column 17)",
  " (in 'TPSC', line 13, column 11 to column 12)",
  " (in 'TPSC', line 13, column 4 to column 17)",
  " (in 'TPSC', line 14, column 11 to column 12)",
  " (in 'TPSC', line 14, column 4 to column 19)",
  " (in 'TPSC', line 15, column 4 to column 37)",
  " (in 'TPSC', line 16, column 4 to column 18)",
  " (in 'TPSC', line 17, column 4 to line 18, column 71)",
  " (in 'TPSC', line 19, column 4 to column 26)",
  " (in 'TPSC', line 10, column 48 to line 20, column 3)"};
template <typename T0__, typename T1__, typename T2__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>, T1__, T2__>,-1,1>
vec_student_t_pdf(const T0__& y_arg__, const T1__& delta, const T2__& sigma,
                  const int& N, std::ostream* pstream__);
template <bool propto__, typename T0__, typename T1__, typename T2__,
          typename T3__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T3__>>* = nullptr>
stan::promote_args_t<stan::base_type_t<T0__>, T1__, T2__, T3__>
skewed_student_t_lpdf(const T0__& y_arg__, const T1__& w, const T2__& delta,
                      const T3__& sigma, const int& N, std::ostream*
                      pstream__);
template <typename T0__, typename T1__, typename T2__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>, T1__, T2__>,-1,1>
vec_student_t_pdf(const T0__& y_arg__, const T1__& delta, const T2__& sigma,
                  const int& N, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             T1__, T2__>;
  int current_statement__ = 0;
  const auto& y = stan::math::to_ref(y_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 32;
    return stan::math::exp(
             stan::math::subtract(
               (((stan::math::lgamma(((delta + 1.0) / 2.0)) -
               stan::math::lgamma((delta / 2.0))) - (0.5 *
               stan::math::log((delta * stan::math::pi())))) -
               stan::math::log(sigma)),
               stan::math::multiply(((delta + 1.0) / 2.0),
                 stan::math::log(
                   stan::math::add(1.0,
                     stan::math::multiply((1.0 / delta),
                       stan::math::square(stan::math::divide(y, sigma))))))));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <bool propto__, typename T0__, typename T1__, typename T2__,
          typename T3__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T3__>>*>
stan::promote_args_t<stan::base_type_t<T0__>, T1__, T2__, T3__>
skewed_student_t_lpdf(const T0__& y_arg__, const T1__& w, const T2__& delta,
                      const T3__& sigma, const int& N, std::ostream*
                      pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             T1__, T2__, T3__>;
  int current_statement__ = 0;
  const auto& y = stan::math::to_ref(y_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    local_scalar_t__ p1 = DUMMY_VAR__;
    current_statement__ = 35;
    stan::math::validate_non_negative_index("v1", "N", N);
    Eigen::Matrix<local_scalar_t__,-1,1> v1 =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
    current_statement__ = 37;
    stan::math::validate_non_negative_index("v2", "N", N);
    Eigen::Matrix<local_scalar_t__,-1,1> v2 =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
    current_statement__ = 39;
    stan::math::validate_non_negative_index("prob", "N", N);
    Eigen::Matrix<local_scalar_t__,-1,1> prob =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
    current_statement__ = 41;
    stan::model::assign(v1,
      stan::math::subtract(1.0,
        stan::math::divide(
          stan::math::add(stan::math::elt_divide(y, stan::math::abs(y)), 1.0),
          2.0)), "assigning variable v1");
    current_statement__ = 42;
    stan::model::assign(v2, stan::math::subtract(1.0, v1),
      "assigning variable v2");
    current_statement__ = 43;
    stan::model::assign(prob,
      stan::math::add(
        stan::math::elt_multiply(
          stan::math::multiply((2.0 * w),
            vec_student_t_pdf(y, delta, (sigma *
              stan::math::sqrt((w / (1.0 - w)))), N, pstream__)), v1),
        stan::math::elt_multiply(
          stan::math::multiply((2.0 * (1 - w)),
            vec_student_t_pdf(y, delta, (sigma *
              stan::math::sqrt(((1.0 - w) / w))), N, pstream__)), v2)),
      "assigning variable prob");
    current_statement__ = 44;
    return stan::math::sum(stan::math::log(prob));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_TPSC final : public model_base_crtp<model_TPSC> {
private:
  int N;
  int P;
  Eigen::Matrix<double,-1,1> y_data__;
  Eigen::Matrix<double,-1,-1> X_data__;
  Eigen::Map<Eigen::Matrix<double,-1,1>> y{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> X{nullptr, 0, 0};
public:
  ~model_TPSC() {}
  model_TPSC(stan::io::var_context& context__, unsigned int
             random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_TPSC_namespace::model_TPSC";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 22;
      context__.validate_dims("data initialization", "N", "int",
        std::vector<size_t>{});
      N = std::numeric_limits<int>::min();
      current_statement__ = 22;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 22;
      stan::math::check_greater_or_equal(function__, "N", N, 0);
      current_statement__ = 23;
      context__.validate_dims("data initialization", "P", "int",
        std::vector<size_t>{});
      P = std::numeric_limits<int>::min();
      current_statement__ = 23;
      P = context__.vals_i("P")[(1 - 1)];
      current_statement__ = 23;
      stan::math::check_greater_or_equal(function__, "P", P, 0);
      current_statement__ = 24;
      stan::math::validate_non_negative_index("y", "N", N);
      current_statement__ = 25;
      context__.validate_dims("data initialization", "y", "double",
        std::vector<size_t>{static_cast<size_t>(N)});
      y_data__ = Eigen::Matrix<double,-1,1>::Constant(N,
                   std::numeric_limits<double>::quiet_NaN());
      new (&y) Eigen::Map<Eigen::Matrix<double,-1,1>>(y_data__.data(), N);
      {
        std::vector<local_scalar_t__> y_flat__;
        current_statement__ = 25;
        y_flat__ = context__.vals_r("y");
        current_statement__ = 25;
        pos__ = 1;
        current_statement__ = 25;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 25;
          stan::model::assign(y, y_flat__[(pos__ - 1)],
            "assigning variable y", stan::model::index_uni(sym1__));
          current_statement__ = 25;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 26;
      stan::math::validate_non_negative_index("X", "N", N);
      current_statement__ = 27;
      stan::math::validate_non_negative_index("X", "P", P);
      current_statement__ = 28;
      context__.validate_dims("data initialization", "X", "double",
        std::vector<size_t>{static_cast<size_t>(N), static_cast<size_t>(P)});
      X_data__ = Eigen::Matrix<double,-1,-1>::Constant(N, P,
                   std::numeric_limits<double>::quiet_NaN());
      new (&X) Eigen::Map<Eigen::Matrix<double,-1,-1>>(X_data__.data(), N, P);
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 28;
        X_flat__ = context__.vals_r("X");
        current_statement__ = 28;
        pos__ = 1;
        current_statement__ = 28;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 28;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 28;
            stan::model::assign(X, X_flat__[(pos__ - 1)],
              "assigning variable X", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 28;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 29;
      stan::math::validate_non_negative_index("beta", "P", P);
      current_statement__ = 30;
      stan::math::validate_non_negative_index("log_lik", "N", N);
      current_statement__ = 31;
      stan::math::validate_non_negative_index("ystar", "N", N);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = 1 + 1 + 1 + P;
  }
  inline std::string model_name() const final {
    return "model_TPSC";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_TPSC_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      local_scalar_t__ w = DUMMY_VAR__;
      current_statement__ = 1;
      w = in__.template read_constrain_lub<local_scalar_t__,
            jacobian__>(0.0001, 0.9999, lp__);
      local_scalar_t__ delta = DUMMY_VAR__;
      current_statement__ = 2;
      delta = in__.template read_constrain_lb<local_scalar_t__,
                jacobian__>(0, lp__);
      local_scalar_t__ sigma = DUMMY_VAR__;
      current_statement__ = 3;
      sigma = in__.template read_constrain_lb<local_scalar_t__,
                jacobian__>(0, lp__);
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(P, DUMMY_VAR__);
      current_statement__ = 4;
      beta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(P);
      {
        current_statement__ = 18;
        lp_accum__.add(stan::math::uniform_lpdf<propto__>(w, 0, 1));
        current_statement__ = 19;
        lp_accum__.add(stan::math::inv_gamma_lpdf<propto__>(delta, 5, 5));
        current_statement__ = 20;
        lp_accum__.add(stan::math::inv_gamma_lpdf<propto__>(sigma, 5, 5));
        current_statement__ = 21;
        lp_accum__.add(skewed_student_t_lpdf<false>(
                         stan::math::subtract(y,
                           stan::math::multiply(X, beta)), w, delta, sigma,
                         N, pstream__));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_TPSC_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      double w = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 1;
      w = in__.template read_constrain_lub<local_scalar_t__,
            jacobian__>(0.0001, 0.9999, lp__);
      double delta = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 2;
      delta = in__.template read_constrain_lb<local_scalar_t__,
                jacobian__>(0, lp__);
      double sigma = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 3;
      sigma = in__.template read_constrain_lb<local_scalar_t__,
                jacobian__>(0, lp__);
      Eigen::Matrix<double,-1,1> beta =
        Eigen::Matrix<double,-1,1>::Constant(P,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 4;
      beta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(P);
      out__.write(w);
      out__.write(delta);
      out__.write(sigma);
      out__.write(beta);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      Eigen::Matrix<double,-1,1> log_lik =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> ystar =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      int z = std::numeric_limits<int>::min();
      double x1 = std::numeric_limits<double>::quiet_NaN();
      double x2 = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 17;
      for (int i = 1; i <= N; ++i) {
        current_statement__ = 10;
        z = stan::math::bernoulli_rng(w, base_rng__);
        current_statement__ = 11;
        x1 = -stan::math::abs(
                stan::math::student_t_rng(delta, 0, (sigma *
                  stan::math::sqrt((w / (1.0 - w)))), base_rng__));
        current_statement__ = 12;
        x2 = stan::math::abs(
               stan::math::student_t_rng(delta, 0, (sigma *
                 stan::math::sqrt(((1.0 - w) / w))), base_rng__));
        current_statement__ = 13;
        stan::model::assign(ystar, ((x1 * z) + (x2 * (1 - z))),
          "assigning variable ystar", stan::model::index_uni(i));
        current_statement__ = 14;
        stan::model::assign(ystar,
          (stan::model::rvalue(ystar, "ystar", stan::model::index_uni(i)) +
          stan::math::multiply(
            stan::model::rvalue(X, "X", stan::model::index_uni(i),
              stan::model::index_omni()), beta)), "assigning variable ystar",
          stan::model::index_uni(i));
        current_statement__ = 15;
        stan::model::assign(log_lik,
          skewed_student_t_lpdf<false>(
            stan::math::rep_vector(
              (stan::model::rvalue(y, "y", stan::model::index_uni(i)) -
              stan::math::multiply(
                stan::model::rvalue(X, "X", stan::model::index_uni(i),
                  stan::model::index_omni()), beta)), 1), w, delta, sigma, 1,
            pstream__), "assigning variable log_lik",
          stan::model::index_uni(i));
      }
      out__.write(log_lik);
      out__.write(ystar);
      out__.write(z);
      out__.write(x1);
      out__.write(x2);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ w = DUMMY_VAR__;
      current_statement__ = 1;
      w = in__.read<local_scalar_t__>();
      out__.write_free_lub(0.0001, 0.9999, w);
      local_scalar_t__ delta = DUMMY_VAR__;
      current_statement__ = 2;
      delta = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, delta);
      local_scalar_t__ sigma = DUMMY_VAR__;
      current_statement__ = 3;
      sigma = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, sigma);
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(P, DUMMY_VAR__);
      current_statement__ = 4;
      stan::model::assign(beta,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(P),
        "assigning variable beta");
      out__.write(beta);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "w", "double",
        std::vector<size_t>{});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "delta", "double",
        std::vector<size_t>{});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "sigma", "double",
        std::vector<size_t>{});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "beta", "double",
        std::vector<size_t>{static_cast<size_t>(P)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ w = DUMMY_VAR__;
      current_statement__ = 1;
      w = context__.vals_r("w")[(1 - 1)];
      out__.write_free_lub(0.0001, 0.9999, w);
      local_scalar_t__ delta = DUMMY_VAR__;
      current_statement__ = 2;
      delta = context__.vals_r("delta")[(1 - 1)];
      out__.write_free_lb(0, delta);
      local_scalar_t__ sigma = DUMMY_VAR__;
      current_statement__ = 3;
      sigma = context__.vals_r("sigma")[(1 - 1)];
      out__.write_free_lb(0, sigma);
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(P, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 4;
        beta_flat__ = context__.vals_r("beta");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 4;
          stan::model::assign(beta, beta_flat__[(pos__ - 1)],
            "assigning variable beta", stan::model::index_uni(sym1__));
          current_statement__ = 4;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(beta);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"w", "delta", "sigma", "beta"};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"log_lik", "ystar", "z", "x1", "x2"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{},
                std::vector<size_t>{}, std::vector<size_t>{},
                std::vector<size_t>{static_cast<size_t>(P)}};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(N)},
             std::vector<size_t>{static_cast<size_t>(N)},
             std::vector<size_t>{}, std::vector<size_t>{},
             std::vector<size_t>{}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "w");
    param_names__.emplace_back(std::string() + "delta");
    param_names__.emplace_back(std::string() + "sigma");
    for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "ystar" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "z");
      param_names__.emplace_back(std::string() + "x1");
      param_names__.emplace_back(std::string() + "x2");
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "w");
    param_names__.emplace_back(std::string() + "delta");
    param_names__.emplace_back(std::string() + "sigma");
    for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "ystar" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "z");
      param_names__.emplace_back(std::string() + "x1");
      param_names__.emplace_back(std::string() + "x2");
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"w\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"delta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(P) + "},\"block\":\"parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"},{\"name\":\"ystar\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"},{\"name\":\"z\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"},{\"name\":\"x1\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"x2\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"w\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"delta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(P) + "},\"block\":\"parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"},{\"name\":\"ystar\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"},{\"name\":\"z\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"},{\"name\":\"x1\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"x2\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((1 + 1) + 1) + P);
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * (((((N + N)
      + 1) + 1) + 1));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((1 + 1) + 1) + P);
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * (((((N + N)
      + 1) + 1) + 1));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_TPSC_namespace::model_TPSC;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_TPSC_namespace::profiles__;
}
#endif
#endif
