% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_raptor.R
\name{tidy_raptor}
\alias{tidy_raptor}
\title{Calculate Travel Times with RAPTOR Algorithm}
\usage{
tidy_raptor(
  gtfs,
  min_departure = "0:0:0",
  max_arrival = "23:59:59",
  dates = NULL,
  stop_ids,
  arrival = FALSE,
  time_range = 3600,
  max_transfers = NULL,
  keep = "all",
  filter = TRUE
)
}
\arguments{
\item{gtfs}{A GTFS object, preferably of class `wizardgtfs`. If not, the function will attempt to convert it using `GTFSwizard::as_wizardgtfs()`.}

\item{min_departure}{A string representing the earliest departure time, in "HH:MM:SS" format. Defaults to `"0:0:0"`.}

\item{max_arrival}{A string representing the latest arrival time, in "HH:MM:SS" format. Defaults to `"23:59:59"`.}

\item{dates}{A date (in `"YYYY-MM-DD"` format) to filter the GTFS dataset to specific calendar days. Defaults to `NULL`, meaning the furthest date.}

\item{stop_ids}{A character vector of stop IDs from where journeys should start (or end, if `arrival = TRUE`).}

\item{arrival}{Logical. If `FALSE` (default), journeys start from `stop_ids`. If `TRUE`, journeys end at `stop_ids`.}

\item{time_range}{Either a range in seconds (numeric) or a vector with the minimal and maximal departure time (e.g., `c(0, 3600)` or `"HH:MM:SS"`) describing the journey window.}

\item{max_transfers}{Maximum number of transfers allowed. Defaults to `NULL` (no limit).}

\item{keep}{One of `"all"`, `"shortest"`, `"earliest"`, or `"latest"`. Determines which journeys to retain:
- `"all"`: All journeys are returned (default).
- `"shortest"`: Only journeys with the shortest travel time.
- `"earliest"`: Journeys arriving at stops the earliest.
- `"latest"`: Journeys arriving at stops the latest.}

\item{filter}{A logical to filter for min_departure, max_arrivel, and dates. Defaults to `TRUE`.}
}
\value{
A tibble containing the RAPTOR algorithm results, including:
\describe{
  \item{from_stop_id}{The ID of the stop where the journey starts.}
  \item{to_stop_id}{The ID of the stop where the journey ends.}
  \item{departure_time}{Departure time from the origin stop.}
  \item{arrival_time}{Arrival time at the destination stop.}
  \item{travel_time}{Total travel time in seconds.}
}
}
\description{
The `tidy_raptor` function calculates travel times from a set of origin stops to all reachable stops within a GTFS dataset.
It uses the RAPTOR (Round-Based Public Transit Routing) algorithm from the `tidytransit` package and integrates it with the GTFSwizard framework.
}
\note{
Ensure that the `stop_times` is present and correctly structured in the GTFS dataset.
Time values in `min_departure`, `max_arrival`, and `time_range` should be correctly formatted to avoid errors.
`max_arrival` must be 23:59:59 or earlier.
}
\examples{
tidy_raptor(for_rail_gtfs,
   min_departure = '06:20:00',
   max_arrival = '09:40:00',
   dates = "2021-12-13",
   max_transfers = 2,
   keep = "all",
   stop_ids = '66')

}
\seealso{
[tidytransit::raptor()], [GTFSwizard::as_wizardgtfs()], [GTFSwizard::filter_time()]
}
