% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_.R
\name{plot_frequency}
\alias{plot_frequency}
\title{Plot System Frequency by Hour}
\usage{
plot_frequency(gtfs)
}
\arguments{
\item{gtfs}{A GTFS object. This should ideally be of the `wizardgtfs` class, or it will be converted.}
}
\value{
A `plotly` interactive plot displaying hourly frequency distributions, including:

  - Hourly Distribution: Boxplots showing frequency distribution across hours.

  - Hourly Average Frequency: A line indicating the weighted average frequency for each hour.

  - Overall Average Frequency: A dashed line marking the system's overall average frequency.
}
\description{
`plot_frequency` generates an interactive plot of the frequency of trips by hour across the GTFS dataset. The plot shows hourly trip distributions, hourly average frequency, and an overall average frequency for the system, providing insights into peak times and overall transit service frequency.
}
\details{
The function first calculates hourly and overall average frequencies using a weighted mean based on `pattern_frequency`. Frequencies are plotted by hour of the day to visualize the system's trip distribution patterns.
}
\examples{
if (interactive()) {
# Plot the frequency of trips by hour for a GTFS object
plot_frequency(for_rail_gtfs)
}

}
\seealso{
[GTFSwizard::get_frequency()]
}
