% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_gtfs.R
\name{read_gtfs}
\alias{read_gtfs}
\title{Read GTFS file}
\usage{
read_gtfs(file.path, files = NULL, quiet = TRUE, ...)
}
\arguments{
\item{file.path}{A path to a .zip GTFS file.}

\item{files}{A character vector containing the text files to be read from the GTFS zip (without the .txt extension). Defaults to NULL, which reads all files.}

\item{quiet}{Logical. If TRUE, suppresses messages from gtfsio::import_gtfs(). Defaults to TRUE.}

\item{...}{Additional arguments to pass to gtfsio::import_gtfs().}
}
\value{
A `wizardgtfs` object: a list of tibbles representing each text file in the .zip and a tibble for services by date.
}
\description{
Reads GTFS files from a .zip file.
}
\details{
If no specific files are indicated, all GTFS files within the zip archive are read. After importing, the function converts the GTFS data into a `wizardgtfs` object, which is tailored for efficient handling and analysis of transit data.
}
\note{
Additional notes can be added here if needed.
}
\examples{
\dontrun{
gtfs_data <- read_gtfs("path/to/gtfs.zip")
}

}
\seealso{
[GTFSwizard::as_wizardgtfs()]
}
