% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_wizardgtfs.R
\name{as_wizardgtfs}
\alias{as_wizardgtfs}
\title{Convert GTFS Object to wizardgtfs Format}
\usage{
as_wizardgtfs(gtfs_list, build_shapes = TRUE)
}
\arguments{
\item{gtfs_list}{A GTFS object in list or `tidygtfs` format.}

\item{build_shapes}{Logical. If `TRUE`, builds the shapes table if it is missing in the provided GTFS object. Default is `TRUE`.}
}
\value{
An object of class `wizardgtfs`, which includes multiple data frames for transit data analysis.
}
\description{
`as_wizardgtfs` transforms a GTFS object into the `wizardgtfs` format, providing enhanced functionality and compatibility with the GTFSwizard package. This function supports GTFS objects in various formats, including `tidygtfs` and list-based structures, and can optionally create a shapes table if it is missing.
}
\details{
- `as_wizardgtfs` is a generic function with S3 methods for different GTFS object formats.

- The `wizardgtfs` format includes additional processing and checks, such as validation of unique IDs and structure formatting.
}
\examples{
# Convert a GTFS object to wizardgtfs format
gtfs_wizard <- as_wizardgtfs(for_rail_gtfs, build_shapes = TRUE)

}
\seealso{
[GTFSwizard::get_shapes()]
}
