% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_selection.R
\name{cox_all_genes}
\alias{cox_all_genes}
\title{Survival analysis based on gene expression levels.}
\usage{
cox_all_genes(case_disease_component, survival_time, survival_event)
}
\arguments{
\item{case_disease_component}{Disease component matrix (output of the function
\code{generate_disease_component}) having selected only the columns
belonging to disease samples. The names of the rows must be the names of the genes.}

\item{survival_time}{Numeric vector that includes time to the event information}

\item{survival_event}{Numeric vector that indicates if relapse or death
have been produced (0 and 1s).}
}
\value{
A matrix with the results of the application of proportional
hazard models using the expression levels of each gene as covariate.
The \code{coef} column corresponds to the regression coefficient; the
\code{exp_coef} column corresponds to the value of e^coef  (which is
interpreted as the odds ratio); the \code{se_coef} column corresponds
to the standard error of each coefficient; the \code{Z} column corresponds
to the value of coef/se_coef (the higher the Z value, the higher the
significance of the variable) and the \code{Pr_z} column corresponds to
the p-value for each Z value.
}
\description{
It carries out univariate cox proportional hazard models for
the expression levels of each gene included in the provided dataset (case_disease_component)
and their link with relapse-free or overall survival.
}
