% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gsIntersect}
\alias{gsIntersect}
\title{gsIntersect}
\usage{
gsIntersect(gs1, gs2)
}
\arguments{
\item{gs1}{A character vector representing gene symbols in a gene set.}

\item{gs2}{A character vector representing gene symbols in a second gene set.}
}
\value{
A character vector consisting of the overlap of the two gene sets.
}
\description{
For two character vectors, returns the set of shared elements. This is used by GSNA to find shared genes
in two gene sets.
}
\details{
This version of the function is used in gsnORAtest_cpp. (In another version of the function, used in
\code{gsnFilterGeneSetCollectionList()} and accessible only from C++ the first argument is gs1Set, a set of strings
of type \code{std::set<std::string>}.)

This function does essentially what R's base::intersect does, so it is not necessarily useful to export.
}
\examples{

library(GSNA)

# We can extract 2 gene sets from the sample data:
Bai.gsc <- tmod2gsc( Bai_gsc.tmod )
M29994.gs = Bai.gsc[['M29994']]
M40825.gs = Bai.gsc[['M40825']]

# Find the intersection:
intersect.gs <- gsIntersect( gs1 = M29994.gs, gs2 = M40825.gs )

}
