% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grin.barplt.R
\name{grin.barplt}
\alias{grin.barplt}
\title{GRIN Bar Plot}
\usage{
grin.barplt(grin.res, count.genes, lsn.colors = NULL)
}
\arguments{
\item{grin.res}{GRIN results (output of the grin.stats function).}

\item{count.genes}{vector with gene names of a list of genes to be added to the bar plot.}

\item{lsn.colors}{Lesion colors (If not provided by the user, colors will be automatically assigned using default.grin.colors function).}
}
\value{
Function return a stacked bar plot with number of patients affected by all different types of lesions in the pre-specified list of genes of interest.
}
\description{
Function return a stacked bar plot with number of patients affected by all different types of lesions in a pre-specified list of genes of interest.
}
\details{
Function will use the input list of gene names and extract the number of patients affected by all different types of lesions in those genes from the GRIN results table (output of the grin.stats function).
}
\examples{
data(lesion.data)
data(hg19.gene.annotation)
data(hg19.chrom.size)

# run GRIN analysis using grin.stats function
grin.results=grin.stats(lesion.data,
                        hg19.gene.annotation,
                        hg19.chrom.size)

# specify a list of genes to be included in the bar plot (driver genes)
count.genes=as.vector(c("TAL1", "FBXW7", "PTEN", "IRF8","NRAS",
                        "BCL11B", "MYB", "LEF1","RB1", "MLLT3", "EZH2", "ETV6", "CTCF",
                        "JAK1", "KRAS", "RUNX1", "IKZF1", "KMT2A", "RPL11", "TCF7",
                        "WT1", "JAK2", "JAK3", "FLT3"))
# return the stacked barplot
grin.barplt(grin.results, count.genes)
}
\seealso{
\code{\link[=grin.stats]{grin.stats()}}
}
\author{
{Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org} and Stanley Pounds \email{stanley.pounds@stjude.org}}
}
