% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomewide.lsn.plot.R
\name{genomewide.lsn.plot}
\alias{genomewide.lsn.plot}
\title{Genome-wide Lesion Plot}
\usage{
genomewide.lsn.plot(
  grin.res,
  ordered = FALSE,
  pt.order = NULL,
  lsn.colors = NULL,
  max.log10q = NULL
)
}
\arguments{
\item{grin.res}{GRIN results (output of the grin.stats function).}

\item{ordered}{By default the function will order the patient IDs alphabetically. However, users can specify a certain patient's order in the genomewide lesion plot by specifying ordered=TRUE and pass a data frame with new patient's order to the pt.order argument.}

\item{pt.order}{data.frame of two columns "ID" that has patient IDs matching the unique IDs in the lesion data file and "pts.order" that has the new patient's order listed as numbers that range from 1:n.patients (Should be only specified if ordered=TRUE).}

\item{lsn.colors}{a vector of lesion colors (If not provided by the user, colors will be automatically assigned using default.grin.colors function).}

\item{max.log10q}{Maximum log10 q value for genes in the GRIN results table to be added to the plot. If max.log10q=100 for example, all -log10q values>100, will be adjusted to 100 in the plot.}
}
\value{
The function return a genome-wide lesion plot (all chromosomes) in the middle panel. For each locus, Panel on the left shows -log10 q value and the Panel on the right show the number of subjects affected by all different types of lesions color coded by lesion category.
}
\description{
Function return a genomewide lesion plot for all lesion types affecting different chromosomes.
}
\details{
The function use the genome-wide plotting coordinates obtained from the compute.gw.coordinates function and plot the whole set of lesions affecting subjects included in the dataset in the middle panel of the figure. Two additional side panels show the number of affected subjects and -log10 q value of each locus to be affected by all different types of lesions.
}
\examples{
data(lesion.data)
data(hg19.gene.annotation)
data(hg19.chrom.size)

# Run GRIN model using grin.stats function
grin.results=grin.stats(lesion.data,
                        hg19.gene.annotation,
                        hg19.chrom.size)

# prepare the genomewide lesion plot using genomewide.lsn.plot function with patient IDs ordered
# alphabetically:
genomewide.plot=genomewide.lsn.plot(grin.results, max.log10q=50)

# To pass certain patients order to the genomewide.lsn.plot function, the user should specify
# a certain patients order using the pt.order argument.
}
\references{
Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link[=compute.gw.coordinates]{compute.gw.coordinates()}}
}
\author{
{Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org} and Stanley Pounds \email{stanley.pounds@stjude.org}}
}
