% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_multiqc.R
\name{run_multiqc}
\alias{run_multiqc}
\title{Generate combined QC report for Salmon and FastQC}
\usage{
run_multiqc(fastqc_dir, salmon_dir, destdir)
}
\arguments{
\item{fastqc_dir}{directory where all the FastQC files are saved.}

\item{salmon_dir}{directory of the salmon files.}

\item{destdir}{directory where you want to save the combined QC report.}
}
\value{
HTML report.
}
\description{
\code{run_fastqc} generates a single HTML report from the fastQC
reports and salmon read mapping results using MultiQC.
}
\examples{

\dontrun{
run_multiqc(fastqc_dir=tempdir(),salmon_dir=tempdir(),
destdir=tempdir())
}

}
\references{
Philip Ewels, Mans Magnusson, Sverker Lundin, and Max Kaller (2016):
MultiQC: summarize analysis results for multiple tools and samples 
in a single report. Bioinformatics, 32(19), 3047-3048.
\url{https://doi.org/10.1093/bioinformatics/btw354}
}
