% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgreen_plots.R
\name{nutrient_tserie}
\alias{nutrient_tserie}
\title{Output load time series plot}
\usage{
nutrient_tserie(green_file, sh_file, basin_name, plot.type)
}
\arguments{
\item{green_file}{data frame. Nutrient Load by source apportionment of
nutrient for each year and catchments.}

\item{sh_file}{sf object. The spatial information.}

\item{basin_name}{character. The title of the plot.}

\item{plot.type}{character. Alternative of the plot: output load (t) by
source; gr1: Basin average by Shreve (t/y/km2); gr2: Outlet total (kt/y);
gr3: Outlet by source apportionment (kt/y).}
}
\value{
No return value, called for the side effect of drawing a plot
}
\description{
Creates a time series plot showing basin model results
}
\examples{
\donttest{
# the data of the TN scenario
data(catch_data_TN)
data(annual_data_TN)
data(sh_file)
# the parameter to assess the basin model
alpha_p <- 35.09
alpha_l <- 0.02
sd_coef <- 0.2
# years in which the model should be executed
loc_years <- 1990:2018
# Computing the source apportionment
basin_sa <- green_shares(catch_data_TN, annual_data_TN, alpha_p, alpha_l,
sd_coef, loc_years)
# The title of the plot
plotTitle <- "Time series Load Output for the Lay Basin"
# Output Load Basin average time series (lines)
nutrient_tserie(basin_sa, sh_file, plotTitle, "gr1")
# Total Load in the Basin Outlet time series (lines)
nutrient_tserie(basin_sa, sh_file, plotTitle, "gr2")
# Total Load in the Basin Outlet by source apportionment time series (lines)
nutrient_tserie(basin_sa, sh_file, plotTitle, "gr3")
}

}
