% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRAB_Simu.R
\name{GRAB.SimubVec}
\alias{GRAB.SimubVec}
\title{GRAB: simulate random effect (i.e. bVec) based on family structure}
\usage{
GRAB.SimubVec(nSub, nFam, FamMode, tau)
}
\arguments{
\item{nSub}{the number of unrelated subjects in simulations, if \code{nSub = 0}, then all subjects are related to at least one of the others.}

\item{nFam}{the number of families in simulation, if \code{nFam = 0}, then all subjects are unrelated to each other.}

\item{FamMode}{\code{"4-members"}, \code{"10-members"}, or \code{"20-members"}. Check \code{Details} section of function \code{help(GRAB.SimuGMat)} for more details.}

\item{tau}{variance component}
}
\value{
a data frame including two columns: ID and random effect following a multivariate normal distribution
}
\description{
Simulate random effect (i.e. bVec) based on family structure
}
\examples{
nSub <- 10
nFam <- 1
FamMode <- "10-members"
tau <- 2
bVec <- GRAB.SimubVec(nSub, nFam, FamMode, tau)

}
