% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEstimator.R
\name{getEstimator}
\alias{getEstimator}
\title{Extract the posterior estimate of parameters}
\usage{
getEstimator(object, estimator = "gamma", Pmax = 0, type = "marginal")
}
\arguments{
\item{object}{an object of class \code{GPTCM}}

\item{estimator}{the name of one estimator. Default is the latent indicator
estimator "\code{gamma}". Other options are among
"\code{c('beta', 'zeta', 'eta', 'xi', 'elpd', 'logP')}"}

\item{Pmax}{threshold that truncate the estimator "\code{gamma}" or
"\code{eta}". Default is \code{0}. If \code{Pmax=0.5} and
\code{type="conditional"}, it gives median probability model betas}

\item{type}{the type of output beta. Default is \code{marginal}, giving
marginal beta estimation. If \code{type="conditional"}, it gives beta
estimation conditional on gamma=1}
}
\value{
Return the estimator from an object of class \code{GPTCM}. It is
a matrix or vector
}
\description{
Extract the posterior estimate of the parameters of a \code{GPTCM} class object.
}
\examples{

# simulate data
set.seed(123)
n <- 200 # subjects
p <- 10 # variable selection predictors
L <- 3 # cell types
dat <- simData(n, p, L)

# run a Bayesian GPTCM model: GPTCM-Ber2
fit <- GPTCM(dat, nIter = 10, burnin = 0)

gamma.hat <- getEstimator(fit, estimator = "gamma")

}
\references{
Zhao Z, Kızılaslan F, Wang S, Zucknick M (2025). \emph{Generalized promotion time cure model: A new modeling framework to identify cell-type-specific genes and improve survival prognosis}. arXiv:2509.01001
}
