% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_inverse.R
\name{compute_inverse}
\alias{compute_inverse}
\title{Compute Matrix Inverse For a Covariate Matrix}
\usage{
compute_inverse(mtrx)
}
\arguments{
\item{mtrx}{An n*n covariate matrix}
}
\value{
Inverse matrix
}
\description{
Computes inverse of a covariate matrix using Choleski decomposition.
}
\examples{

set.seed(934)
A <- runif(10)
B <- runif(10)
C = cbind(A, B)
kernel_fn = function(x) exp(-x^2)
D = kernel_fn(as.matrix(dist(C)))
inv_sigma_obs <- compute_inverse(D)

}
