% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GOCore.R
\name{chord_dat}
\alias{chord_dat}
\title{Creates a binary matrix.}
\usage{
chord_dat(data, genes, process, limit)
}
\arguments{
\item{data}{A data frame with at least two coloumns: GO ID|term and genes.
Each row contains exactly one GO ID|term and one gene. A column containing
logFC values is optional and might be used if \code{genes} is missing.}

\item{genes}{A character vector of selected genes OR data frame with coloumns
for gene ID and logFC.}

\item{process}{A character vector of selected processes}

\item{limit}{A vector with two cutoff values (default= c(0,0)). The first
value defines the minimum number of terms a gene has to be assigned to. The
second the minimum number of genes assigned to a selected term.}
}
\value{
A binary matrix
}
\description{
The function creates a matrix which represents the binary
  relation (1= is related to, 0= is not related to) between selected genes
  (row) and processes (column). The resulting matrix can be visualized with
  the \code{\link{GOChord}} function.
}
\details{


If more than one logFC value for each gene is at disposal, only one
  should be used to create the binary matrix. The other values have to be
  added manually later. The parameter \code{limit} can be used to reduce the
  dimension of the calculated matrix. This might be useful to represent the
  data more clearly with \code{GOChord} later on. The first value of the
  vector defines the threshold for the minimum number of terms a gene has to
  be assigned to in order to be represented in the plot. Most of the time it
  is more meaningful to represent genes with various functions. A value of 3
  excludes all genes with less than three term assignments. Whereas the
  second value of the parameter restricts the number of terms according to
  the number of assigned genes. All terms with a count smaller or equal to
  the threshold are excluded.
}
\examples{
\dontrun{
# Load the included dataset
data(EC)

# Building the circ object
circ <- circular_dat(EC$david, EC$genelist)

# Building the binary matrix
chord <- chord_dat(circ, EC$genes, EC$process)

# Excluding genes which are assigned only to a single term
chord <- chord_dat(circ, EC$genes, EC$process, limit = c(1,0))

# Excluding terms with a count smaller than 5
chord <- chord_dat(circ, EC$genes, EC$process, limit = c(0,5))

}
}
\seealso{
\code{\link{GOChord}}
}

