% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/return.ss.ng.int.req.df.r
\name{return.ss.ng.data.req.df}
\alias{return.ss.ng.data.req.df}
\title{Get single sample normal-gamma interim treatment effect OC data.frame}
\usage{
return.ss.ng.data.req.df(
  mu.0.t = 0,
  n.0.t = 1e-04,
  alpha.0.t = 0.25,
  beta.0.t = 1,
  xbar.t = 0.5,
  s.t = 2,
  interim.n.t = 10,
  final.n.t = 40,
  Delta.lrv = 1.25,
  Delta.tv = 1.75,
  tau.tv = 0.1,
  tau.lrv = 0.8,
  tau.ng = 0.65,
  xbar_ng = NULL,
  xbar_go = NULL,
  go.thresh = 0.8,
  ng.thresh = 0.8,
  include_nogo = TRUE
)
}
\arguments{
\item{mu.0.t}{prior mean}

\item{n.0.t}{prior effective sample size}

\item{alpha.0.t}{prior alpha parameter}

\item{beta.0.t}{prior beta parameter}

\item{xbar.t}{sample mean at interim}

\item{s.t}{treatment standard deviation}

\item{interim.n.t}{interim sample sizes}

\item{final.n.t}{final sample size}

\item{Delta.lrv}{TPP Lower Reference Value aka Min TPP}

\item{Delta.tv}{TPP Target Value aka Base TPP}

\item{tau.tv}{threshold associated with Base TPP}

\item{tau.lrv}{threshold associated with Min TPP}

\item{tau.ng}{threshold associated with No-Go}

\item{xbar_ng}{Leave NULL to compute or provide user value}

\item{xbar_go}{Leave NULL to compute or provide user value}

\item{go.thresh}{interim go threshold}

\item{ng.thresh}{interim no-go threshold}

\item{include_nogo}{logical}
}
\value{
returns data.frame to assist with creating interim oc curve in single sample normal-gamma case
}
\description{
Get single sample normal-gamma interim treatment effect OC data.frame
}
\examples{
return.ss.ng.data.req.df()
}
