% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.ts.ng.trt.oc.df.r
\name{get.ts.ng.trt.oc.df}
\alias{get.ts.ng.trt.oc.df}
\title{Get two-sample normal-gamma treatment OC data.frame}
\usage{
get.ts.ng.trt.oc.df(
  mu.0.c = 0,
  n.0.c = 1e-04,
  alpha.0.c = 0.25,
  beta.0.c = 1,
  xbar.c = 0,
  s.c = 4,
  group.c = "Control",
  mu.0.t = 0,
  n.0.t = 1e-04,
  alpha.0.t = 0.25,
  beta.0.t = 1,
  xbar.t = 5,
  s.t = 4,
  group.t = "Treatment",
  Delta.LB = 0,
  Delta.UB = 1.5,
  ARatio = 1,
  N = 50,
  Delta.tv = 1.5,
  Delta.lrv = 1,
  tau.tv = 0.1,
  tau.lrv = 0.65,
  tau.ng = 0,
  npoints = 2,
  n.MC = 500,
  seed = 1234,
  cl = cl,
  goparallel = TRUE
)
}
\arguments{
\item{mu.0.c}{prior mean for control group}

\item{n.0.c}{prior effective sample size for control group}

\item{alpha.0.c}{prior alpha parameter for control group}

\item{beta.0.c}{prior beta parameter for control group}

\item{xbar.c}{sample mean for control group}

\item{s.c}{sample sd for control group}

\item{group.c}{label for control group}

\item{mu.0.t}{prior mean for treatment group}

\item{n.0.t}{prior effective sample size for treatment group}

\item{alpha.0.t}{prior alpha parameter for treatment group}

\item{beta.0.t}{prior beta parameter for treatment group}

\item{xbar.t}{sample mean for treatment group}

\item{s.t}{sample sd for treatment group}

\item{group.t}{label for treatment group}

\item{Delta.LB}{Lower bound for Delta}

\item{Delta.UB}{upper bound for delta}

\item{ARatio}{randomization ratio}

\item{N}{total sample size}

\item{Delta.tv}{Base TPP}

\item{Delta.lrv}{Min TPP}

\item{tau.tv}{threshold associated with Base TPP}

\item{tau.lrv}{threshold associated with Min TPP}

\item{tau.ng}{threshold associated with No-Go}

\item{npoints}{number of points}

\item{n.MC}{n for MC sampling}

\item{seed}{random seed}

\item{cl}{cluster}

\item{goparallel}{a logical to indicate if parallel computing is employed}
}
\value{
A data.frame is returned
}
\description{
Get two-sample normal-gamma treatment OC data.frame
}
\examples{
\donttest{
my.ts.ng.trt.oc.df <- get.ts.ng.trt.oc.df(goparallel=FALSE)
head(my.ts.ng.trt.oc.df)
}
}
\author{
Greg Cicconetti
}
