% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.ts.bin.dec.r
\name{get.ts.bin.dec}
\alias{get.ts.bin.dec}
\title{Get two sample binary decision}
\usage{
get.ts.bin.dec(
  a.con = 1,
  b.con = 1,
  n.con = 40,
  x.con = 5,
  a.trt = 1,
  b.trt = 1,
  n.trt = 40,
  x.trt = 20,
  Delta.tv = 0.25,
  Delta.lrv = 0.2,
  tau.tv = 0.1,
  tau.lrv = 0.8,
  tau.ng = 0.65
)
}
\arguments{
\item{a.con}{prior alpha parameter for control group}

\item{b.con}{prior beta parameter for control group}

\item{n.con}{observed sample size for control group}

\item{x.con}{observed number of responders for control group}

\item{a.trt}{prior alpha parameter for treatment group}

\item{b.trt}{prior beta parameter for treatment group}

\item{n.trt}{observed sample size for treatment group}

\item{x.trt}{observed number of responders for treatment group}

\item{Delta.tv}{TPP Target Value aka Base TPP}

\item{Delta.lrv}{TPP Lower Reference Value aka Min TPP}

\item{tau.tv}{threshold associated with Base TPP}

\item{tau.lrv}{threshold associated with Min TPP}

\item{tau.ng}{threshold associated with No-Go}
}
\value{
returns a data.frame holding Posterior probabilties of interest and Go/No-Go result
}
\description{
Get two sample binary decision
}
\examples{
get.ts.bin.dec()
}
\author{
Greg Cicconetti
}
