% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIFT_checklists_raw.R
\name{GIFT_checklists_raw}
\alias{GIFT_checklists_raw}
\title{GIFT checklists}
\usage{
GIFT_checklists_raw(
  ref_ID = NULL,
  list_ID = NULL,
  namesmatched = FALSE,
  taxon_name = "Tracheophyta",
  floristic_group = "all",
  list_set = NULL,
  taxonomy = NULL,
  GIFT_version = "latest",
  api = "https://gift.uni-goettingen.de/api/extended/"
)
}
\arguments{
\item{ref_ID}{A vector defining the IDs of the references to retrieve.
\code{NULL} by default.}

\item{list_ID}{A vector defining the IDs of the lists to retrieve.
\code{NULL} by default. These lists are retrieved in addition to the lists
contained in the references in \code{ref_ID}.}

\item{namesmatched}{Logical. \code{FALSE} by default, set to \code{TRUE} if you want
the original species name as they came in the references as well as details
on the taxonomic harmonization.}

\item{taxon_name}{Character string corresponding to the taxonomic group
of interest.}

\item{floristic_group}{Character string among these options:
\code{all}, \code{native}, \code{naturalized}, \code{endemic_list}, \code{endemic_ref}.}

\item{list_set}{\code{NULL} by default. If not, it has to be the list table
(see \code{\link[=GIFT_lists]{GIFT_lists()}}). Used internally in \code{\link[=GIFT_checklists]{GIFT_checklists()}} to
avoid downloading the table of lists many times.}

\item{taxonomy}{\code{NULL} by default. If not, it has to be the taxonomy table
(see \code{\link[=GIFT_taxonomy]{GIFT_taxonomy()}}). Used internally in \code{\link[=GIFT_checklists]{GIFT_checklists()}}
to avoid downloading the taxonomy table many times.}

\item{GIFT_version}{character string defining the version of the GIFT
database to use. The function retrieves by default the \code{latest} stable
version. If set to \code{beta}, the most up-to-date version which is still
subject to changes and edits is used.}

\item{api}{character string defining from which API the data will be
retrieved.}
}
\value{
A data frame with 15 or 29 columns (depending on namesmatched). This
data frame contains the species checklist for a given reference/list.
}
\description{
Raw checklists, to combine with other functions.
}
\details{
Here is what each column refers to:

\emph{ref_ID} - Identification number of each reference\cr
\emph{list_ID} - Identification number of each list\cr
\emph{orig_ID} - Identification number of each species name, unchanged from
the sources\cr
\emph{name_ID} - Identification number of each reference\cr
\emph{genus} - Genus of each species\cr
\emph{species_epithet} - Epithet of each species\cr
\emph{subtaxon} - If needed, subtaxon of the species\cr
\emph{author} - Name of the author who described the species\cr
\emph{matched} - Whether a match was found when using a taxonomic
backbone\cr
\emph{epithetscore} - Matching score for the epithet\cr
\emph{overallscore} - Matching score for the overall species name\cr
\emph{resolved} - Whether the species name was resolved\cr
\emph{service} - Service used for the taxonomic harmonization\cr
\emph{work_ID} - Identification number of each species name, after
taxonomic  harmonization\cr
\emph{genus_ID} - Identification number of each genus, after taxonomic
harmonization\cr
\emph{species} - Species name, after taxonomic harmonization\cr
\emph{questionable} - Whether the species occurrence is questionable\cr
\emph{native} - Whether the species is native\cr
\emph{quest_native} - Whether the native information is questionable\cr
\emph{naturalized} - Whether the species is naturalized\cr
\emph{endemic_ref} - Whether the species is endemic within the reference\cr
\emph{quest_end_ref} - Whether the endemic_ref information is
questionable\cr
\emph{endemic_list}- Whether the species is endemic within the list\cr
\emph{quest_end_list} - Whether the endemic_list information is
questionable\cr
\emph{cons_status} - Conservation status of the species
}
\examples{
\donttest{
ex <- GIFT_checklists_raw(list_ID = c(1,5))
}

}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ Weigelt, P, König, C, Kreft, H. GIFT – A Global Inventory of Floras and
 Traits for macroecology and biogeography. J Biogeogr. 2020; 47: 16– 43.
 https://doi.org/10.1111/jbi.13623
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[=GIFT_checklists]{GIFT_checklists()}}
}
