\name{g.analyse}
\alias{g.analyse}
\title{
function to analsyse meta-data generated by \link{g.getmeta} and \link{g.impute}
}
\description{
Analyses the output from other functions within the packages to generate a basic
descriptive summary for each accelerometer data file. Analyses include: Average 
acceleration per day, per measurement, L5M5 analyses (assessment of the five
hours with lowest acceleration and with highest acceleration). Further, the 
traditionally popular variable MVPA is automatically extracted in six variants:
without bout criteria in combination with epoch = epoch length as defined in
g.getmeta (first value of the input argument windowsizes), 1 minute,
and 5 minutes, and for bout durations 1 minute, 5 minutes or 10 minutes in
combination with the epoch length as defined in g.getmeta.

}
\usage{
g.analyse(I, C, M, IMP, qlevels = c(), qwindow = c(0, 24),
quantiletype = 7, L5M5window = c(0, 24), M5L5res = 10,
includedaycrit = 16, ilevels = c(),
winhr = 5, idloc = 1,snloc=1,mvpathreshold = c(),
boutcriter=c(),mvpadur=c(1,5,10),
selectdaysfile=c(),window.summary.size=10,
dayborder=0,bout.metric = 1,
closedbout=FALSE,desiredtz = c(),
IVIS_windowsize_minutes = 60,
IVIS_epochsize_seconds = 3600, iglevels = c(),IVIS.activity.metric=1,
qM5L5=c(), myfun=c())
}

\arguments{
  \item{I}{
    the output from function \link{g.inspectfile}
  }
  \item{C}{
    the output from function \link{g.calibrate}
  }
  \item{M}{
    the output from function \link{g.getmeta}
}
  \item{IMP}{
    the output from function \link{g.impute}
}
  \item{qlevels}{
    array of percentiles for which value needs to be extracted. These need to
    be expressed as a fraction of 1, e.g. c(0.1, 0.5, 0.75). There is no limit
    to the number of percentiles. If left empty then percentiles will not be 
    extracted. Distribution will be derived from short epoch metric data, see
    \link{g.getmeta}.
  }
  \item{qwindow}{
  To specify windows over which all variables are calculated. If value = c(0,24)
  all variables will only be calculated over the full 24 hours in a day, If
  value =c(8,24) variables will be calculated over the window 0-8, 8-24 and 0-24.
  Previously this functionality was limited to the distribution in acceleration
  metric values, but now it also derives N valid hours, L5M5 analysis and MVPA.
  }
  \item{quantiletype}{
  type of quantile function to use (default recommended). For details, see 
  quantile function in STATS package
  }
  \item{L5M5window}{
    Argument depricated after version 1.5-24. This argument used to define the
    start and end time, in 24 hour clock hours, over which L5M5 needs to be
    calculated. Now this is done with argument qwindow.
  }
  \item{M5L5res}{
  resoltion of L5 and M5 analysis in minutes (default: 10 minutes)
  }
  \item{includedaycrit}{
    minimum required number of valid hours in day specific analysis
    (NOTE: there is no minimum required number of hours per day in the summary
    of an entire measurement, every available hour is used to make the best possible
    inference on average metric value per average day)
  }
  \item{ilevels}{
    Levels for acceleration value frequency distribution in mg, e.g. c(0,100,200)
    There is no constriction to the number of levels.
  }
  \item{winhr}{
    Vector of window size(s) (unit: hours) of L5 and M5 analysis (dedault = 5 hours)
  }
  \item{idloc}{
    If value = 1 (default) the code assumes that ID number is stored in the
    obvious header field. If value = 2 the code uses the character string preceding
    the character '_' in the filename as the ID number
  }
  \item{snloc}{
    If value = 1 (default) the code assumes that device serial number is stored in
    the obvious header field. If value = 2 the code uses the character string between
    the first and second character '_' in the filename as the serial number
  }
  \item{mvpathreshold}{
    Threshold for MVPA estimation. This can be a single number or an array of numbers,
    e.g. c(100,120). In the later case the code will estimate MVPA seperately for
    each threshold. If this variable is left blank c() then MVPA is not estimated
  }
    \item{boutcriter}{
    The variable boutcriter is a number between 0 and 1 and defines what fraction
    of a bout needs to be above the mvpathreshold
  }
  \item{mvpadur}{
    default = c(1,5,10). Three bout duration for which MVPA will be calculated
  }
  \item{selectdaysfile}{
  Functionality designed for the London Centre of Longidutinal studies.
  Csv file holding the relation between device serial numbers and measurement days of interest.
  }
    \item{dayborder}{
  Hour at which days start and end (default = 0), value = 4 would mean 4am
  }
  \item{window.summary.size}{
    Functionality designed for the London Centre of Longidutinal studies.
  Size in minutes of the summary window
  }
  \item{bout.metric}{
  This argument used to be called mvpa.2014 and had TRUE or FALSE as its value.
  However, it has now become clear that this aspect of the analyses is still very
  much open for debate. Therefore, I have changed it into an argument where you
  can specify a metric for bout detection based on a number. A description of these
  bout metrics can be found in the new function \link{g.getbout}
  }
  \item{closedbout}{
  If TRUE then count breaks in a bout towards the bout duration. If FALSE then only count
  time spent above the threshold towards the bout duration.
  }
  \item{desiredtz}{
  see \link{g.getmeta}
  }
  \item{IVIS_windowsize_minutes}{
  Window size of the Intradaily Variability (IV) and Interdaily
  Stability (IS) metrics in minutes
  }
  \item{IVIS_epochsize_seconds}{
  Epoch size of the Intradaily Variability (IV) and Interdaily
  Stability (IS) metrics in seconds
  }
  \item{iglevels}{
    Levels for acceleration value frequency distribution in mg used for intensity
    gradient calculation (according to the method by Rowlands 2018). By default this
    is argument is empty and the intensity gradient calculation is not done. 
    The user can either provide a single value (any) to make the intensity gradient use
    the bins c(seq(0,4000,by=25),8000) or the user could specify their own
    distribution. There is no constriction to the number of levels.
  }
   \item{IVIS.activity.metric}{
    see function \link{g.IVIS}
  }
  \item{qM5L5}{
    see function \link{g.getM5L5}
  }
  \item{myfun}{
    External function object to be applied to raw data, see \link{g.getmeta}.
  }
  
   
}
\value{
  g.analyse generated two data,franeL
  \item{\code{summary}}{summary for the file that was analysed}
  \item{\code{daysummary}}{summary per day for the file that was analysed}
  These data.frames are used by function g.report.part2 to generate csv reports.
  An exaplantion of all the columns in the data.frame and subsequent csv reports
  can be found in the package vignette (Output part 2).
}


\examples{
data(data.getmeta)
data(data.inspectfile)
data(data.calibrate)
\dontrun{
  #inspect file:
  I = g.inspectfile(datafile)
  
  #autocalibration:
  C = g.calibrate(datafile) 
  
  #get meta-data:
  M = g.getmeta(datafile, desiredtz = "Europe/London", 
  windowsizes = c(5, 900, 3600),
  daylimit = FALSE, offset = c(0, 0, 0), 
  scale = c(1, 1, 1), tempoffset = c(0, 0, 0))
}


#impute meta-data:
IMP = g.impute(M = data.getmeta, I = data.inspectfile)

#analyse and produce summary:
A = g.analyse(I = data.inspectfile, C = data.calibrate,
M = data.getmeta, IMP)

}
\author{
Vincent T van Hees <v.vanhees@accelting.com>
}