library(GGIR)
test_that("chainof5parts", {
  Ndays = 4
  create_test_acc_csv(Nmin=Ndays*1440)
  create_test_sleeplog_csv()
  fn = "123A_testaccfile.csv"
  sleeplog_fn = "testsleeplogfile.csv"
  metadatadir = paste0(getwd(),"/output_test")
  desiredtz="Europe/London"
  dn = "output_test"
  if (file.exists(dn))  unlink(dn,recursive=TRUE)
  # part 1
  g.part1(datadir=fn,outputdir=getwd(),f0=1,f1=1,overwrite=TRUE,desiredtz=desiredtz,
                     studyname="test",do.enmo = TRUE,do.anglez=TRUE,do.cal = TRUE)
  expect_that(dir.exists(dn),is_true())
  rn = dir("output_test/meta/basic/",full.names = TRUE)
  load(rn[1])
  
  expect_that(round(C$scale,digits=5),equals(c(0.98480, 0.98337, 0.98432)))
  expect_that(nrow(M$metalong),equals(383))
  expect_that(M$metalong[2,1],equals("2016-06-23T09:15:00+0100"))
  expect_that(nrow(M$metashort),equals(68940))
  expect_that(round(mean(M$metashort$ENMO),digits=5),equals(0.03172))
  expect_that(I$monc,equals(3))
  expect_that(I$sf,equals(3))
  expect_that(I$dformc,equals(2))
  expect_that(C$npoints,equals(14848))
  
  # part 2
  g.part2(datadir=fn,metadatadir=metadatadir,f0=1,f1=1, idloc = 2,desiredtz=desiredtz,
          strategy = 1,overwrite=TRUE, hrs.del.start = 0,hrs.del.end = 0,
          maxdur = Ndays, includedaycrit = 0)
  g.report.part2(metadatadir=metadatadir,f0=1,f1=1,maxdur=Ndays)
  
  dirname = "output_test/meta/ms2.out/"
  rn = dir(dirname,full.names = TRUE)
  load(rn[1])
  summarycsv = "output_test/results/part2_summary.csv"
  daysummarycsv = "output_test/results/part2_daysummary.csv"
  
  expect_that(dir.exists(dirname),is_true())
  expect_that(file.exists(summarycsv),is_true())
  expect_that(file.exists(daysummarycsv),is_true())
  expect_that(nrow(IMP$metashort),equals(68940))
  expect_that(round(mean(IMP$metashort$ENMO),digits=5),equals(0.03172))
  expect_that(round(as.numeric(SUM$summary$meas_dur_dys),digits=5),equals(3.98958))
  expect_that(round(as.numeric(SUM$summary$`M5_ENMO_mg_0-24h`), digits = 4),equals(80.6532))
  expect_that(round(as.numeric(SUM$summary$WD_mean_ENMO_mg_24hr), digits = 4),equals(30.1371))
  
  # part 3
  g.part3(metadatadir=metadatadir,f0=1,f1=1,anglethreshold = 5,desiredtz=desiredtz,
                     timethreshold = 5,ignorenonwear=FALSE,overwrite=TRUE) 
  dirname = "output_test/meta/ms3.out/"
  rn = dir(dirname,full.names = TRUE)
  load(rn[1])
  
  expect_that(dir.exists(dirname),is_true())
  expect_that(round(sum(sib.cla.sum[,4:7]),digits=0),equals(10115))
  expect_that(sib.cla.sum$sib.end.time[1],equals("2016-06-23 12:15:30"))
  
  # part 4
  g.part4(datadir=fn,metadatadir=metadatadir,f0=1,f1=1,
          idloc=2,loglocation = sleeplog_fn, do.visual=TRUE,outliers.only = FALSE,
          excludefirstlast=FALSE,criterror = 1,includenightcrit=0,nnights=7,colid=1,coln1=2,
          relyonsleeplog=FALSE,
          storefolderstructure=FALSE, overwrite=TRUE)
  dirname = "output_test/meta/ms4.out/"
  rn = dir(dirname,full.names = TRUE)
  load(rn[1])
  vis_sleep_file = "output_test/results/visualisation_sleep.pdf"
  g.report.part4(datadir=fn,metadatadir=metadatadir,loglocation = sleeplog_fn,f0=1,f1=1)
  
  expect_that(dir.exists(dirname),is_true())
  expect_that(file.exists(vis_sleep_file),is_true())
  expect_that(round(nightsummary$acc_dur_sibd[1],digits=4),equals(4.5389))
  expect_that(as.logical(nightsummary$acc_available[1]),is_true())
  expect_that(as.logical(nightsummary$sleeplog_used[1]),is_true())
  
  #part 5
  g.part5(datadir=fn,metadatadir=metadatadir,f0=1,f1=1,desiredtz=desiredtz,
          strategy=1,maxdur=Ndays,hrs.del.start=0,hrs.del.end =0,
                     loglocation= sleeplog_fn,
                     overwrite=TRUE, excludefirstlast=FALSE)
  dirname = "output_test/meta/ms5.out/"
  rn = dir(dirname,full.names = TRUE)
  load(rn[1])
  expect_that(dir.exists(dirname),is_true())
  expect_that(file.exists(rn[1]),is_true())
  expect_that(nrow(output),equals(3))
  expect_that(ncol(output),equals(134))
  expect_that(round(as.numeric(output$acc_wake[1]),digits=4),equals(31.1708)) 
  expect_that(round(as.numeric(output$dur_day_min[3]),digits=4),equals(639.75))
  expect_that(output$L5TIME[1],equals("2016-06-25T00:00:05+0100"))
  
  # Somehow, the following test to now work yet on Travis, but they do work locally.
  # Possibly I will need to break down the problem by splitting up function g.part5 and designing
  # tests for the individual parts
  # expect_that(output[2,23],equals("28.0888888888889")) #
  # expect_that(output$window_length_in_hours[2],equals("28.0888888888889")) #
  # expect_that(round(as.numeric(output$window_length_in_hours[2]),digits=4),equals(28.0889)) #
  # expect_that(round(as.numeric(output$dur_nightwak_MOD100_400_min[1]),digits=4),equals(7.9167)) #
  # expect_that(round(as.numeric(output$dur_TMODday_min[2]),digits=4),equals(79.6667)) #
  # expect_that(round(as.numeric(output$ACC_MVPA_D10T100_mg[3]),digits=4),equals(542.2611)) #
  # expect_that(round(as.numeric(output$Nblocks_MVPA_D10T100[1])),equals(1)) #
  
  # g.report.part5(metadatadir=metadatadir,f0=1,f1=1,loglocation=sleeplog_fn,
  #                includenightcrit=0,includedaycrit=0)
  # 
  
  # dn = "output_test"
  # if (file.exists(dn))  unlink(dn,recursive=TRUE)
  if (file.exists(fn)) file.remove(fn)
  if (file.exists(sleeplog_fn)) file.remove(sleeplog_fn)
})
  


