% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GFD-function.R
\name{GFD}
\alias{GFD}
\title{Tests for general factorial designs}
\usage{
GFD(formula, data = NULL, nperm = 10000, alpha = 0.05, plot_CI = FALSE,
  Title = NULL, line_width = 2)
}
\arguments{
\item{formula}{A model \code{\link{formula}} object. The left hand side
contains the response variable and the right hand side contains the factor
variables of interest. An interaction term must be specified.}

\item{data}{A data.frame, list or environment containing the variables in 
\code{formula}. The default option is \code{NULL}.}

\item{nperm}{The number of permutations used for calculating the permuted 
Wald-type statistic. The default option is 10000.}

\item{alpha}{A number specifying the significance level; the default is 0.05.}

\item{plot_CI}{An indicator for whether a plot of the results should be 
shown; the default is \code{FALSE}.}

\item{Title}{A title for the plot. The default is \code{NULL}.}

\item{line_width}{A number specifying the \code{lwd}-option for the plots.
The default is 2.}
}
\value{
A \code{GFD} object containing the following components:
\item{Descriptive}{Some descriptive statistics of the data for all factor
  level combinations. Displayed are the number of individuals per factor
  level combination, the mean, variance and 100*(1-alpha)\% confidence
  intervals.}
 \item{WTS}{The value of the WTS along with degrees of freedom of the central chi-square distribution and p-value, as well as the p-value of the permutation procedure.}
 \item{ATS}{The value of the ATS, degrees of freedom of the central F distribution and the corresponding p-value.}
}
\description{
The GFD function calculates the Wald-type statistic (WTS), the ANOVA-type 
statistic (ATS) as well as a permutation version of the WTS for general 
factorial designs.
}
\details{
The package provides the Wald-type statistic, a permuted version
  thereof as well as the ANOVA-type statistic for general factorial designs,
  even with non-normal error terms and/or heteroscedastic variances. It is
  implemented for both crossed and hierarchically nested designs and allows
  for an arbitrary number of factor combinations as well as different sample
  sizes in the crossed design.
}
\examples{
GFD(weightgain ~ source * type, data = HSAUR::weightgain)

data(startup)
model <- GFD(Costs ~ company, data = startup)
summary(model)

}
\references{
Friedrich, S., Konietschke, F., Pauly, M.(2015). GFD - An R-package
for the Analysis of General Factorial Designs - along with a Graphical User Interface. Journal of Statistical Software.
}

