% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rq.R
\name{global_rq}
\alias{global_rq}
\title{Global quantile regression}
\usage{
global_rq(
  nsim,
  formula.full,
  formula.reduced,
  taus,
  data,
  contrasts = NULL,
  permutationstrategy = c("Freedman-Lane", "Freedman-Lane+remove zeros",
    "within nuisance", "remove location", "remove location scale", "remove quantile"),
  savefuns = FALSE,
  rq.args = NULL,
  lm.args = NULL,
  GET.args = NULL,
  mc.cores = 1L,
  mc.args = NULL,
  cl = NULL
)
}
\arguments{
\item{nsim}{The number of random permutations.}

\item{formula.full}{The formula specifying the general linear model,
see \code{formula} in \code{\link[stats]{lm}}.}

\item{formula.reduced}{The formula of the reduced model with nuisance factors only. This model
should be nested within the full model.}

\item{taus}{The quantiles to be used.}

\item{data}{data.frame where to look for variables.}

\item{contrasts}{Passed directly to \code{rq}.}

\item{permutationstrategy}{The permutation strategy to be used. See details.}

\item{savefuns}{Logical. If TRUE, then the functions from permutations are saved to the attribute
simfuns.}

\item{rq.args}{Additional arguments passed to \code{rq}.}

\item{lm.args}{A named list of additional arguments to be passed to \code{\link[stats]{lm}}. See details.}

\item{GET.args}{A named list of additional arguments to be passed to \code{\link{global_envelope_test}},
e.g. \code{typeone} specifies the type of multiple testing control, FWER or FDR.
See \code{\link{global_envelope_test}} for the defaults and available options.}

\item{mc.cores}{The number of cores to use, i.e. at most how many child processes will be run simultaneously.
Must be at least one, and parallelization requires at least two cores. On a Windows computer mc.cores must be 1
(no parallelization). For details, see \code{\link{mclapply}}, for which the argument is passed.
Parallelization can be used in generating simulations and in calculating the second stage tests.}

\item{mc.args}{A named list of additional arguments to be passed to \code{\link{mclapply}}.
Only relevant if \code{mc.cores} is more than 1.}

\item{cl}{Allows parallelization through the use of \code{\link{parLapply}} (works also
in Windows), see the argument \code{cl} there, and examples.}
}
\value{
A \code{global_envelope} or \code{combined_global_envelope} object,
which can be printed and plotted directly.
}
\description{
Global tests of significance for the effect of covariates in quantile regression
}
\details{
The possible permutation strategies include
"Freedman-Lane" (FL), "Freedman-Lane+remove zeros" (FL+), "within nuisance" (WN),
"remove location" (RL), "remove location scale" (RLS), "remove quantile" (RQ),
which correspond to those in Mrkvička et al. (Section 4.1-4.6 and Table 1).
}
\examples{
if(require("quantreg", quietly=TRUE)) {
  data("stackloss")
  res <- global_rq(nsim = 19, # Increase nsim for serious analysis!
    formula.full = stack.loss ~ Air.Flow + Water.Temp + Acid.Conc.,
    formula.reduced = stack.loss ~ Water.Temp,
    taus = seq(0.1, 0.9, length=10), permutationstrategy = "remove quantile",
    data = stackloss, GET.args = list(typeone = "fwer"))
  plot(res)
}

}
\references{
Mrkvička, T., Konstantinou, K., Kuronen, M. and Myllymäki, M. (2023) Global quantile regression. arXiv:2309.04746 [stat.ME]. https://doi.org/10.48550/arXiv.2309.04746

Myllymäki, M and Mrkvička, T. (2023). GET: Global envelopes in R. arXiv:1911.06583 [stat.ME]. https://doi.org/10.48550/arXiv.1911.06583

Freedman, D., & Lane, D. (1983) A nonstochastic interpretation of reported significance levels. Journal of Business & Economic Statistics, 1(4), 292-298. doi:10.2307/1391660
}
