\name{gen.simuHaplo_traceback}
\alias{gen.simuHaplo_traceback}
\title{Trace inheritance path for results from gene dropping simulation}
\description{Given the output of a gene dropping simulation using gen.simuHaplo, this function can trace the inheritance path of a proband segment back to the founder it is inherited from}
\usage{gen.simuHaplo_traceback(gen, proID, ancestorID, all_nodes_path, proband_haplotypes_path)}

\arguments{
\item{gen}{An object of class GLgen obtained with gen.genealogy, gen.lineages or gen.branching. Required.}
\item{proID}{Integer ID of the proband to trace back from.}
\item{ancestorID}{Integer ID of the founder, any segment in the proband haplotype inherited from this founder will be traced back}
\item{all_nodes_path}{String of the path to the "All_nodes_haplotypes.txt" output file generated by gen.simulHaplo}
\item{proband_haplotypes_path}{String of the path to the "Proband_Haplotypes.txt" output file generated by gen.simulHaplo}
}

\value{
    returns a dataframe with the following columns: "simulNo", "seg_length", "path_no". For every simulation in the output files where the specified proband inherits
    a segment from the specified founder. "seg_length" is the length of the inherited segment in BP. "path_no" is an integer that specifies the path of inheritance of the segment
    Unique paths of inheritance are simply identified by the order they appear in the outputs file, and the full paths (ID of every individual along the path) are printed to the R console.
    If this is not appearing check that messages are not disabled.
}
\seealso{
\code{\link{gen.genealogy}}
\code{\link{gen.simuHaplo}}
\code{\link{gen.simuHaplo_IBD_compare}}
}
\examples{

gen_table <- data.frame(ind=c(1,2,3,4,5,6,7),
                        mother=c(0,0,2,0,0,5,3),
                        father=c(0,0,1,0,0,4,6),
                        sex=c(1,2,2,1,2,1,1)
)

#convert the genealogy table into a GENLIB object
sample_gen<-gen.genealogy(gen_table) 

gen.graph(sample_gen)
# Simulate the gene dropping from founders to probamds

gen.simuHaplo(sample_gen, simulNo=5, model = 1, model_params = c(1,1), cM_len=c(100,100),
                BP_len = 100000000, all_nodes = 1, outDir=tempdir())

traceback <-gen.simuHaplo_traceback(sample_gen, 7, 1,
                        paste(tempdir(), "All_nodes_haplotypes.txt", sep = "/"),
                        paste(tempdir(), "Proband_Haplotypes.txt", sep="/"))
}
