% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{GENEAratio}
\alias{GENEAratio}
\title{Principal Frequency Ratio}
\usage{
GENEAratio(principals, freq = "Freq", nfr = 3L, ...)
}
\arguments{
\item{principals}{principal frequency}

\item{freq}{single character naming single numeric variable 
in parent environment stating sampling frequency}

\item{nfr}{single integer number of frames to search}

\item{\dots}{other arguments to be swallowed}
}
\value{
single numeric
}
\description{
Calculates the ratio of the principle step frequencies.
}
\details{
Note this function is intended to be called from within 
an apply call in \code{\link{segmentation}}, hence the 
unusual syntax of defining the sampling frequency, freq
as an object in the parent frame
}
\examples{
    Freq <- 100
    GENEAratio(principals = c(0.1, 3.2, 0.3, 0.0, 0.2))
}
\keyword{internal}
