% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BLMCP.R
\name{BLMCP}
\alias{BLMCP}
\title{Accommodating missingness in environmental measurements in gene-environment interaction
analysis: penalized estimation and selection}
\usage{
BLMCP(
  G,
  E,
  Y,
  weight = NULL,
  lambda1,
  lambda2,
  gamma1 = 6,
  gamma2 = 6,
  max_iter = 200
)
}
\arguments{
\item{G}{Input matrix of \code{p} G measurements consisting of \code{n} rows. Each row is an
observation vector.}

\item{E}{Input matrix of \code{q} environmental risk factors. Each row is an observation
vector.}

\item{Y}{Response variable. A quantitative vector for \code{family="continuous"}. For
\code{family="survival"}, \code{Y} should be a two-column matrix with the first column being
the log(survival time) and the second column being the censoring indicator. The indicator is a
binary variable, with "1" indicating dead, and "0" indicating right censored.}

\item{weight}{Observation weights.}

\item{lambda1}{A user supplied lambda for group MCP, where each main G effect and its
corresponding interactions are regarded as a group.}

\item{lambda2}{A user supplied lambda for MCP accommodating interaction selection.}

\item{gamma1}{The regularization parameter of the group MCP penalty.}

\item{gamma2}{The regularization parameter of the MCP penalty.}

\item{max_iter}{Maximum number of iterations.}
}
\value{
An object with S3 class \code{"BLMCP"} is returned, which is a list with the following components.
\item{call}{The call that produced this object.}
\item{alpha}{Matrix of the coefficients for main E effects.}
\item{beta}{The matrix of the regression coefficients for all main G effects (the first row)
and interactions.}
\item{df}{The number of nonzeros.}
\item{BIC}{Bayesian Information Criterion.}
\item{aa}{The indicator representing whether the algorithm reaches convergence.}
}
\description{
The joint gene-environment (G-E) interaction analysis approach developed in Liu et al, 2013.
To accommodate "main effects, interactions" hierarchy, two types of penalty, group minimax
concave penalty (MCP) and MCP are adopted. Specifically, for each G factor, its main effect
and corresponding G-E interactions are regarded as a group, where the group MCP is imposed to
identify whether this G factor has any effect at all. In addition, the MCP is imposed on the
interaction terms to further identify important interactions.
}
\examples{
set.seed(100)
sigmaG=AR(0.3,100)
G=MASS::mvrnorm(250,rep(0,100),sigmaG)
E=matrix(rnorm(250*5),250,5)
E[,2]=E[,2]>0;E[,3]=E[,3]>0
alpha=runif(5,2,3)
beta=matrix(0,5+1,100);beta[1,1:8]=runif(8,2,3)
beta[2:4,1]=runif(3,2,3);beta[2:3,2]=runif(2,2,3);beta[5,3]=runif(1,2,3)

# continuous with Normal error
y1=simulated_data(G,E,alpha,beta,error=rnorm(250),family="continuous")
fit1<-BLMCP(G,E,y1,weight=NULL,lambda1=0.05,lambda2=0.06,gamma1=3,gamma2=3,max_iter=200)
coef1=coef(fit1)
y1_hat=predict(fit1,E,G)
plot(fit1)

# survival with Normal error
y2=simulated_data(G,E,alpha,beta,rnorm(250,0,1),family="survival",0.7,0.9)
fit2<-BLMCP(G,E,y2,weight=NULL,lambda1=0.05,lambda2=0.06,gamma1=3,gamma2=3,max_iter=200)
coef2=coef(fit2)
y2_hat=predict(fit2,E,G)
plot(fit2)
}
\references{
Mengyun Wu, Yangguang Zang, Sanguo Zhang, Jian Huang, and Shuangge Ma.
\emph{Accommodating missingness in environmental measurements in gene-environment interaction
analysis. Genetic Epidemiology, 41(6):523-554, 2017.}\cr  Jin Liu, Jian Huang, Yawei Zhang,
Qing Lan, Nathaniel Rothman, Tongzhang Zheng, and Shuangge Ma.
\emph{Identification of gene-environment interactions in cancer studies using penalization.
Genomics, 102(4):189-194, 2013.}
}
\seealso{
\code{predict}, and \code{coef}, and \code{plot}, and \code{bic.BLMCP} and
\code{Augmentated.data} methods.
}
