% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemEquityShare_3_3.R
\name{gemEquityShare_3_3}
\alias{gemEquityShare_3_3}
\title{A General Equilibrium Model with Equity Shares}
\usage{
gemEquityShare_3_3(...)
}
\arguments{
\item{...}{arguments to be passed to the function sdm2.}
}
\description{
A general equilibrium model with equity shares and dividend.
}
\examples{
\donttest{
dst.firm <- node_new("output",
                     type = "FIN",
                     rate = c(1, dividend.rate = 0.25),
                     "cc1", "equity.share"
)
node_set(dst.firm, "cc1",
         type = "CD",
         alpha = 2, beta = c(0.5, 0.5),
         "prod", "lab"
)

dst.laborer <- node_new("util",
                        type = "Leontief",  a = 1,
                        "prod"
)

dst.shareholder <- Clone(dst.laborer)

ge <- sdm2(
  A = list(dst.firm, dst.laborer, dst.shareholder),
  B = diag(c(1, 0, 0)),
  S0Exg = {
    S0Exg <- matrix(NA, 3, 3)
    S0Exg[2, 2] <- S0Exg[3, 3] <- 100
    S0Exg
  },
  names.commodity = c("prod", "lab", "equity.share"),
  names.agent = c("firm", "laborer", "shareholder"),
  numeraire = "prod"
)

ge$p # The third component is the dividend per unit of share.
ge$DV
ge$SV

## Set the growth rate to 0.03.
ge <- sdm2(
  A = list(dst.firm, dst.laborer, dst.shareholder),
  B = diag(c(1, 0, 0)),
  S0Exg = {
    S0Exg <- matrix(NA, 3, 3)
    S0Exg[2, 2] <- S0Exg[3, 3] <- 100
    S0Exg
  },
  names.commodity = c("prod", "lab", "equity.share"),
  names.agent = c("firm", "laborer", "shareholder"),
  numeraire = "prod",
  GRExg = 0.03
)

ge$z
ge$p

#### an equivalent intertemporal model.
gr <- 0.03 # the growth rate of the labor supply
Gamma.beta <- 0.8 # the subjective discount factor
np <- 5 # the number of economic periods
y1 <- 100 # the initial product supply

n <- 2 * np - 1 # the number of commodity kinds
m <- np # the number of agent kinds

names.commodity <- c(paste0("prod", 1:np), paste0("lab", 1:(np - 1)))
names.agent <- c(paste0("firm", 1:(np - 1)), "consumer")

# the exogenous supply matrix.
S0Exg <- S0Exg <- matrix(NA, n, m, dimnames = list(names.commodity, names.agent))
S0Exg[paste0("lab", 1:(np - 1)), "consumer"] <- 100 * (1 + gr)^(0:(np - 2))
S0Exg["prod1", "consumer"] <- y1

# the output coefficient matrix.
B <- matrix(0, n, m, dimnames = list(names.commodity, names.agent))
for (k in 1:(np - 1)) {
  B[paste0("prod", k + 1), paste0("firm", k)] <- 1
}

dstl.firm <- list()
for (k in 1:(np - 1)) {
  dstl.firm[[k]] <- node_new(
    "prod",
    type = "CD",
    alpha = 2, beta = c(0.5, 0.5),
    paste0("prod", k), paste0("lab", k)
  )
}

dst.consumer <- node_new(
  "util",
  type = "CES", es = 1,
  alpha = 1,  beta = prop.table(Gamma.beta^(1:np)),
  paste0("prod", 1:np)
)

ge <- sdm2(
  A = c(dstl.firm, dst.consumer),
  B = B,
  S0Exg = S0Exg,
  names.commodity = names.commodity,
  names.agent = names.agent,
  numeraire = "prod1",
  policy = makePolicyHeadTailAdjustment(gr = gr, np = np)
)

ge$z
growth_rate(ge$z[1:4])
ge$p[6:9] / ge$p[1:4]
addmargins(ge$D, 2)
addmargins(ge$S, 2)
}
}
